/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

class XyzPoint {
    int x;
    int y;
    int z;

    XyzPoint(XyzPoint you) {
        this.x = you.x;
        this.y = you.y;
        this.z = you.z;
    }

    XyzPoint(int x_, int y_, int z_) {
        this.x = x_;
        this.y = y_;
        this.z = z_;
    }

    void set(XyzPoint you) {
        this.x = you.x;
        this.y = you.y;
        this.z = you.z;
    }

    double mag2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    double distanceTo(XyzPoint other) {
        int dx = other.x - this.x;
        int dy = other.y - this.y;
        int dz = other.z - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    XyzPoint midPointTo(XyzPoint other) {
        return new XyzPoint((other.x + this.x) / 2, (other.y + this.y) / 2, (other.z + this.z) / 2);
    }

    static XyzPoint[] makeXyz(int[] ax, int[] ay, int[] az, int length) {
        XyzPoint[] result = new XyzPoint[length];
        for (int i = 0; i < length; ++i) {
            result[i] = new XyzPoint(ax[i], ay[i], az[i]);
        }
        return result;
    }

    public String toString() {
        return "x: " + this.x + ", y: " + this.y + ", z: " + this.z;
    }

    static void dump(XyzPoint[] foo, int length) {
        for (int i = 0; i < length; ++i) {
            System.out.println("Point " + i + ": " + foo[i]);
        }
        System.out.println("");
    }
}

