/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.VEdge;
import com.kurumi.matr.XyzPoint;
import java.util.Vector;

public class VPoly {
    private int maxRadials = 8;
    private VEdge firstEdge;
    private VEdge lastEdge;
    private XyzPoint[] inCorner = new XyzPoint[this.maxRadials];
    private XyzPoint[] outCorner = new XyzPoint[this.maxRadials];
    private VEdge[] inMeds = new VEdge[this.maxRadials];
    private VEdge[] outMeds = new VEdge[this.maxRadials];
    private int[] insertPoint = new int[this.maxRadials];
    private int nDoubles = 0;
    public Vector<XyzPoint> v = new Vector();

    VPoly() {
    }

    public boolean isEmpty() {
        return this.v.isEmpty();
    }

    private void addCommon(VEdge inbound) {
        if (this.isEmpty()) {
            this.firstEdge = new VEdge(inbound);
        } else {
            this.connect(inbound);
            if (this.nDoubles >= 1 && this.outCorner[this.nDoubles - 1] == null) {
                this.outCorner[this.nDoubles - 1] = this.intersectLast(inbound);
            }
        }
    }

    public void add(VEdge inbound, VEdge outbound) {
        this.addCommon(inbound);
        this.v.addElement(new XyzPoint(inbound.far));
        this.v.addElement(new XyzPoint(outbound.far));
        this.lastEdge = new VEdge(outbound);
    }

    public void add(VEdge inbound, VEdge inMedian, VEdge outMedian, VEdge outbound) {
        if (!this.isEmpty()) {
            this.inCorner[this.nDoubles] = this.intersectLast(inbound);
        }
        this.addCommon(inbound);
        this.v.addElement(new XyzPoint(inbound.far));
        this.v.addElement(new XyzPoint(inMedian.far));
        this.inMeds[this.nDoubles] = new VEdge(inMedian);
        this.outMeds[this.nDoubles] = new VEdge(outMedian);
        this.insertPoint[this.nDoubles] = this.v.size();
        ++this.nDoubles;
        this.v.addElement(new XyzPoint(outMedian.far));
        this.v.addElement(new XyzPoint(outbound.far));
        this.lastEdge = new VEdge(outbound);
    }

    public void makeCaps() {
        for (int i = this.nDoubles - 1; i >= 0; --i) {
            double outDist;
            XyzPoint middleOut;
            double inDist;
            if (this.inCorner[i] == null && this.outCorner[i] == null) {
                XyzPoint inp = this.inMeds[i].near.midPointTo(this.outMeds[i].near);
                this.v.insertElementAt(VPoly.along(this.inMeds[i], this.inMeds[i].near, 8), this.insertPoint[i]);
                this.v.insertElementAt(inp, this.insertPoint[i] + 1);
                this.v.insertElementAt(VPoly.along(this.outMeds[i], this.outMeds[i].near, 8), this.insertPoint[i] + 2);
                continue;
            }
            boolean useInCorner = this.inCorner[i] == null ? false : (this.outCorner[i] == null ? true : (inDist = (middleOut = this.inMeds[i].far.midPointTo(this.outMeds[i].far)).distanceTo(this.inCorner[i])) < (outDist = middleOut.distanceTo(this.outCorner[i])));
            XyzPoint corner = useInCorner ? this.inCorner[i] : this.outCorner[i];
            XyzPoint incap = VPoly.perpendicular(this.inMeds[i], corner);
            XyzPoint outcap = VPoly.perpendicular(this.outMeds[i], corner);
            this.v.insertElementAt(VPoly.along(this.inMeds[i], incap, 8), this.insertPoint[i]);
            this.v.insertElementAt(incap.midPointTo(outcap), this.insertPoint[i] + 1);
            this.v.insertElementAt(VPoly.along(this.outMeds[i], outcap, 8), this.insertPoint[i] + 2);
        }
    }

    public void close() {
        if (this.v.isEmpty()) {
            return;
        }
        this.connect(this.firstEdge);
        if (this.nDoubles > 0 && this.inCorner[0] == null) {
            this.inCorner[0] = this.intersectLast(this.firstEdge);
        }
        if (this.nDoubles > 0 && this.outCorner[this.nDoubles - 1] == null) {
            this.outCorner[this.nDoubles - 1] = this.intersectLast(this.firstEdge);
        }
        this.makeCaps();
    }

    private void connect(VEdge edge) {
        XyzPoint p = this.intersectLast(edge);
        if (p == null) {
            if (this.lastEdge.near.mag2() > edge.near.mag2()) {
                this.v.addElement(new XyzPoint(this.lastEdge.near));
                this.v.addElement(VPoly.along(edge, edge.near, 24));
            } else {
                this.v.addElement(VPoly.along(this.lastEdge, this.lastEdge.near, 24));
                this.v.addElement(new XyzPoint(edge.near));
            }
        } else if (VPoly.cosine(this.lastEdge, edge) > 0.5) {
            this.v.addElement(VPoly.along(this.lastEdge, p, 12));
            this.v.addElement(VPoly.along(edge, p, 12));
        } else if (VPoly.cosine(this.lastEdge, edge) > -0.01) {
            this.v.addElement(VPoly.along(this.lastEdge, p, 4));
            this.v.addElement(VPoly.along(edge, p, 4));
        } else {
            this.v.addElement(new XyzPoint(p));
        }
    }

    private static long dotxz(VEdge left, VEdge right) {
        return (left.far.x - left.near.x) * (right.far.x - right.near.x) + (left.far.z - left.near.z) * (right.far.z - right.near.z);
    }

    private static double cosine(VEdge left, VEdge right) {
        return (double)VPoly.dotxz(left, right) / (left.mag() * right.mag());
    }

    private static XyzPoint along(VEdge e, XyzPoint isect, int offset) {
        double len = e.mag();
        int xa = (int)((double)isect.x + (double)offset / len * (double)(e.far.x - isect.x));
        int za = (int)((double)isect.z + (double)offset / len * (double)(e.far.z - isect.z));
        return new XyzPoint(xa, 0, za);
    }

    private static XyzPoint alongProp(VEdge e, XyzPoint isect, double prop) {
        double len = e.mag();
        return VPoly.along(e, isect, (int)(prop * len));
    }

    private static XyzPoint perpendicular(VEdge edge, XyzPoint offPoint) {
        XyzPoint a = edge.near;
        XyzPoint b = edge.far;
        XyzPoint c = offPoint;
        double len2 = edge.mag2();
        double rnum = (a.z - c.z) * (a.z - b.z) - (a.x - c.x) * (b.x - a.x);
        double xi = (double)a.x + rnum / len2 * (double)(b.x - a.x);
        double zi = (double)a.z + rnum / len2 * (double)(b.z - a.z);
        return new XyzPoint((int)xi, 0, (int)zi);
    }

    private XyzPoint intersectLast(VEdge edge) {
        XyzPoint a = this.lastEdge.near;
        XyzPoint b = this.lastEdge.far;
        XyzPoint c = edge.near;
        XyzPoint d = edge.far;
        double denom = (b.x - a.x) * (d.z - c.z) - (b.z - a.z) * (d.x - c.x);
        if (denom == 0.0) {
            return null;
        }
        double rnum = (a.z - c.z) * (d.x - c.x) - (a.x - c.x) * (d.z - c.z);
        double r = rnum / denom;
        double xi = (double)a.x + r * (double)(b.x - a.x);
        double zi = (double)a.z + r * (double)(b.z - a.z);
        return new XyzPoint((int)xi, 0, (int)zi);
    }
}

