/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.MyTools;
import com.kurumi.matr.SignUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;

class TextSign {
    private static final int maxNames = 10;
    private int numNames = 0;
    private String[] name = new String[10];
    private int[] arrow = new int[10];
    private Point topCenter = new Point(0, 0);

    TextSign(int x, int y) {
        this.topCenter.setLocation(x, y);
    }

    public void setLocation(int x, int y) {
        this.topCenter.setLocation(x, y);
    }

    public void add(String name_, int arrow_) {
        if (this.numNames < 10) {
            this.name[this.numNames] = new String(name_);
            this.arrow[this.numNames] = arrow_;
            ++this.numNames;
        }
    }

    public void clear() {
        this.numNames = 0;
    }

    public boolean isEmpty() {
        return this.numNames == 0;
    }

    private Dimension calcSize(Graphics g) {
        int widest = 0;
        int h = 0;
        FontMetrics fm = g.getFontMetrics(SignUtils.getFont());
        for (int i = 0; i < this.numNames; ++i) {
            if (this.name[i].length() <= 0) continue;
            int wThis = fm.stringWidth(this.name[i]);
            widest = Math.max(widest, wThis += SignUtils.arrowCount(this.arrow[i]) * 16);
        }
        h = fm.getHeight() * this.numNames + (this.numNames + 1) * 2;
        return new Dimension(widest += 8, h);
    }

    public void draw(Graphics g1) {
        if (this.numNames == 0) {
            return;
        }
        Graphics2D g2 = MyTools.modernize(g1);
        SignUtils.setColorScheme(2);
        Dimension d = this.calcSize(g2);
        SignUtils.drawFramedRect(g2, this.topCenter.x - d.width / 2, this.topCenter.y, d);
        for (int i = 0; i < this.numNames; ++i) {
            int yc = this.topCenter.y + (2 * i + 1) * d.height / (2 * this.numNames);
            SignUtils.drawStringWithArrow(g2, this.topCenter.x, yc, this.name[i], this.arrow[i]);
        }
    }
}

