/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.Empire;
import com.kurumi.matr.Junction;
import com.kurumi.matr.MyTools;
import com.kurumi.matr.Realm;
import com.kurumi.matr.SignUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;

class Signpost {
    private static final Dimension metaPanelSize = new Dimension(40, 18);
    private static final Dimension numberPanelSize = new Dimension(40, 36);
    private static final int spacing = 2;
    Point stakeLoc;
    int r1;
    int r2;
    int d1;
    int d2;
    int ar = 0;
    private static String[] dirText = new String[]{"NORTH", "JCT", "EAST", "BEGIN", "SOUTH", "END", "WEST"};

    Signpost(int x, int y) {
        this.stakeLoc = new Point(x, y);
    }

    public void setLocation(int x, int y) {
        this.stakeLoc.setLocation(x, y);
    }

    public void setRoutes(int d1_, int r1_, int d2_, int r2_, int ar_) {
        this.d1 = d1_;
        this.r1 = r1_;
        this.d2 = d2_;
        this.r2 = r2_;
        this.ar = ar_;
    }

    public void setRoutes(Realm r, Point here, int aheadDir, int facing) {
        int realDir = -1;
        Junction j = r.pToJ(here);
        this.d2 = -1;
        this.d1 = -1;
        this.r2 = 0;
        this.r1 = 0;
        this.ar = -1;
        switch (facing) {
            case 6: {
                this.ar = 1;
                realDir = j.ridToLeftDir(aheadDir);
                break;
            }
            case 0: {
                this.ar = 2;
                realDir = aheadDir;
                break;
            }
            case 2: {
                this.ar = 4;
                realDir = j.ridToRightDir(aheadDir);
            }
        }
        if (realDir >= 0) {
            int tempDir;
            int rid = j.ridAt(realDir, 0);
            if (rid > 0) {
                tempDir = r.routes[rid].getLogDirection();
                this.r1 = r.routes[rid].getNumber();
                int n = this.d1 = j.isRidFwdAt(realDir, 0) ? tempDir : Junction.getReverseDirection(tempDir);
            }
            if ((rid = j.ridAt(realDir, 1)) > 0) {
                tempDir = r.routes[rid].getLogDirection();
                this.r2 = r.routes[rid].getNumber();
                this.d2 = j.isRidFwdAt(realDir, 1) ? tempDir : Junction.getReverseDirection(tempDir);
            }
        }
    }

    private static void drawRouteNum(Graphics2D g2, int xx, int yy, int routeNumber) {
        FontMetrics numFm = g2.getFontMetrics(Empire.routeTabFont);
        String s = String.valueOf(routeNumber);
        int sw = numFm.stringWidth(s);
        int dh = numFm.getHeight() / 2 - 2;
        g2.setFont(Empire.routeTabFont);
        g2.setColor(Color.black);
        g2.drawString(s, xx - sw / 2, yy + Signpost.numberPanelSize.height / 2 + dh);
    }

    private static void drawDirText(Graphics2D g2, int xx, int yy, int dir) {
        FontMetrics dirFm = g2.getFontMetrics(Empire.dirTabFont);
        String text = dirText[dir];
        int sw = dirFm.stringWidth(text);
        int dh = dirFm.getHeight() / 2 - 3;
        g2.setFont(Empire.dirTabFont);
        g2.setColor(Color.black);
        g2.drawString(text, xx - sw / 2, yy + Signpost.metaPanelSize.height / 2 + dh);
    }

    public void draw(Graphics g1) {
        Graphics2D g2 = MyTools.modernize(g1);
        int y = this.stakeLoc.y - 48;
        SignUtils.setColorScheme(1);
        SignUtils.drawPost(g2, this.stakeLoc.x, this.stakeLoc.y);
        if (this.ar > 0) {
            SignUtils.drawFramedRect(g2, this.stakeLoc.x - Signpost.metaPanelSize.width / 2, y -= Signpost.metaPanelSize.height, metaPanelSize);
            SignUtils.drawArrow(g2, this.stakeLoc.x, y + Signpost.metaPanelSize.height / 2, this.ar);
            y -= 2;
        }
        if (this.r2 > 0) {
            SignUtils.drawFramedRect(g2, this.stakeLoc.x - Signpost.numberPanelSize.width / 2, y -= Signpost.numberPanelSize.height, numberPanelSize);
            Signpost.drawRouteNum(g2, this.stakeLoc.x, y, this.r2);
            y -= 2;
        }
        if (this.d2 > -1 && this.d2 != this.d1) {
            SignUtils.drawFramedRect(g2, this.stakeLoc.x - Signpost.metaPanelSize.width / 2, y -= Signpost.metaPanelSize.height, metaPanelSize);
            Signpost.drawDirText(g2, this.stakeLoc.x, y, this.d2);
            y -= 2;
        }
        if (this.r1 > 0) {
            SignUtils.drawFramedRect(g2, this.stakeLoc.x - Signpost.numberPanelSize.width / 2, y -= Signpost.numberPanelSize.height, numberPanelSize);
            Signpost.drawRouteNum(g2, this.stakeLoc.x, y, this.r1);
            y -= 2;
        }
        if (this.d1 > -1) {
            SignUtils.drawFramedRect(g2, this.stakeLoc.x - Signpost.metaPanelSize.width / 2, y -= Signpost.metaPanelSize.height, metaPanelSize);
            Signpost.drawDirText(g2, this.stakeLoc.x, y, this.d1);
            y -= 2;
        }
    }
}

