/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;

class SignUtils {
    public static final int postThick = 4;
    public static final int arrowWidth = 16;
    private static final int arrowOffset = 10;
    public static final int clearance = 48;
    public static final int margin = 2;
    public static final int noArrow = 0;
    public static final int leftArrow = 1;
    public static final int aheadArrow = 2;
    public static final int rightArrow = 4;
    public static final int leftAheadArrow = 3;
    public static final int leftRightArrow = 5;
    public static final int aheadRightArrow = 6;
    public static final int route = 1;
    public static final int street = 2;
    public static final int bgStreet = 1;
    public static final int fgStreet = 2;
    public static final int bgRoute = 3;
    public static final int fgRoute = 4;
    private static Color bgStreetColor = Color.green.darker();
    private static Color fgStreetColor = Color.white;
    private static Color bgRouteColor = Color.white;
    private static Color fgRouteColor = Color.black;
    private static int colorScheme = 2;
    private static Font textFont = new Font("Helvetica", 0, 12);

    SignUtils() {
    }

    public static void setColor(int which, Color c) {
        switch (which) {
            case 1: {
                bgStreetColor = c;
                break;
            }
            case 2: {
                fgStreetColor = c;
                break;
            }
            case 3: {
                bgRouteColor = c;
                break;
            }
            case 4: {
                fgRouteColor = c;
            }
        }
    }

    public static void setColorScheme(int what) {
        colorScheme = what;
    }

    public static void setFont(Font f) {
        textFont = f;
    }

    public static Font getFont() {
        return textFont;
    }

    public static void translatePoly(Polygon p, int dx, int dy) {
        int i = 0;
        while (i < p.npoints) {
            int n = i;
            p.xpoints[n] = p.xpoints[n] + dx;
            int n2 = i++;
            p.ypoints[n2] = p.ypoints[n2] + dy;
        }
    }

    public static void drawArrow(Graphics2D g, int xc, int yc, int arr) {
        Polygon p;
        switch (arr) {
            case 1: {
                int[] x = new int[]{6, -2, -2, -8, -2, -2, 6};
                int[] y = new int[]{3, 3, 6, 0, -6, -3, -3};
                p = new Polygon(x, y, x.length);
                break;
            }
            case 2: {
                int[] xa = new int[]{3, 3, 6, 0, -6, -3, -3};
                int[] ya = new int[]{4, -1, -1, -7, -1, -1, 4};
                p = new Polygon(xa, ya, xa.length);
                SignUtils.translatePoly(p, 0, 1);
                break;
            }
            case 4: {
                int[] xr = new int[]{-6, 2, 2, 8, 2, 2, -6};
                int[] yr = new int[]{3, 3, 6, 0, -6, -3, -3};
                p = new Polygon(xr, yr, xr.length);
                break;
            }
            default: {
                return;
            }
        }
        g.setColor(colorScheme == 2 ? fgStreetColor : fgRouteColor);
        SignUtils.translatePoly(p, xc, yc);
        g.fillPolygon(p);
    }

    public static void drawStringWithArrow(Graphics2D g, int cx, int cy, String str, int arrow_) {
        FontMetrics myFm = g.getFontMetrics(textFont);
        int sw = myFm.stringWidth(str);
        int dh = myFm.getHeight() / 2 - 2;
        switch (arrow_) {
            case 1: {
                SignUtils.drawArrow(g, (cx += 8) - sw / 2 - 10, cy, arrow_);
                break;
            }
            case 2: 
            case 4: {
                SignUtils.drawArrow(g, (cx -= 8) + sw / 2 + 10, cy, arrow_);
                break;
            }
            case 3: {
                SignUtils.drawArrow(g, cx - sw / 2 - 10, cy, 1);
                SignUtils.drawArrow(g, cx + sw / 2 + 10, cy, 2);
                break;
            }
            case 5: {
                SignUtils.drawArrow(g, cx - sw / 2 - 10, cy, 1);
                SignUtils.drawArrow(g, cx + sw / 2 + 10, cy, 4);
                break;
            }
            case 6: {
                SignUtils.drawArrow(g, cx - sw / 2 - 10, cy, 2);
                SignUtils.drawArrow(g, cx + sw / 2 + 10, cy, 4);
            }
        }
        g.setFont(textFont);
        g.setColor(colorScheme == 2 ? fgStreetColor : fgRouteColor);
        g.drawString(str, cx - sw / 2, cy + dh);
    }

    public static int arrowCount(int arrow_) {
        int count = 0;
        while (arrow_ > 0) {
            if (arrow_ % 2 != 0) {
                ++count;
            }
            arrow_ /= 2;
        }
        return count;
    }

    public static void drawFramedRect(Graphics g, int x, int y, Dimension d) {
        g.setColor(colorScheme == 2 ? bgStreetColor : bgRouteColor);
        g.fillRect(x, y, d.width, d.height);
        g.setColor(colorScheme == 2 ? fgStreetColor : fgRouteColor);
        g.drawRect(x, y, d.width, d.height);
    }

    public static void drawPost(Graphics g, int centerX, int bottomY) {
        g.setColor(Color.gray);
        g.fillRect(centerX - 2, bottomY - 48, 4, 48);
    }
}

