/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.Junction;
import com.kurumi.matr.MapFrame;
import com.kurumi.matr.MatrPanel;
import com.kurumi.matr.PathTool;
import com.kurumi.matr.Realm;
import com.kurumi.matr.RoadMapCanvas;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JFrame;

public class RoadMapFrame
extends JFrame
implements MapFrame,
AdjustmentListener {
    private Choice chClick = new Choice();
    private Button bZoomIn = new Button("+");
    private Button bZoomOut = new Button("-");
    private Button bFit = new Button("Fit");
    private Button bClose = new Button("Close");
    private Realm myRealm;
    RoadMapCanvas map;
    private PathTool myPathTool;
    private Scrollbar hbar = new Scrollbar(0);
    private Scrollbar vbar = new Scrollbar(1);

    RoadMapFrame(Realm r, MatrPanel mp) {
        super("Map");
        this.setDefaultCloseOperation(1);
        this.hbar.setUnitIncrement(16);
        this.vbar.setUnitIncrement(16);
        this.map = new RoadMapCanvas(r, mp, this);
        this.myPathTool = new PathTool(r, this.map, mp);
        this.myRealm = r;
        this.vbar.addAdjustmentListener(this);
        this.hbar.addAdjustmentListener(this);
        for (int i = 0; i < RoadMapCanvas.clickStrings.length; ++i) {
            this.chClick.addItem(RoadMapCanvas.clickStrings[i]);
        }
        this.setLayout(new BorderLayout());
        Panel p = new Panel();
        p.setLayout(new BorderLayout());
        p.add("Center", this.map);
        p.add("South", this.hbar);
        p.add("East", this.vbar);
        this.add("Center", p);
        p = new Panel();
        p.setLayout(new FlowLayout(2));
        p.add(new Label("Mouse click:"));
        p.add(this.chClick);
        p.add(this.bZoomIn);
        p.add(this.bZoomOut);
        p.add(this.bFit);
        p.add(this.bClose);
        this.add("South", p);
        this.setBounds(50, 50, 760, 600);
        this.map.setClickAction(3);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getAdjustable() == this.vbar) {
            this.map.updatey(e.getValue());
        }
        if (e.getAdjustable() == this.hbar) {
            this.map.updatex(e.getValue());
        }
    }

    @Override
    public boolean action(Event e, Object o) {
        if (e.target == this.bClose) {
            this.setVisible(false);
            return true;
        }
        if (e.target == this.bZoomIn) {
            this.map.zoomIn();
            this.map.repaint();
            return true;
        }
        if (e.target == this.bZoomOut) {
            this.map.zoomOut();
            this.map.repaint();
            return true;
        }
        if (e.target == this.bFit) {
            this.map.zoomToFit();
            this.map.repaint();
            return true;
        }
        if (e.target == this.chClick) {
            int clickAction = this.chClick.getSelectedIndex();
            this.map.setClickAction(clickAction);
            if (clickAction == 4) {
                this.myPathTool.setVisible(true);
            } else {
                this.myPathTool.setVisible(false);
            }
            return true;
        }
        return super.action(e, o);
    }

    public void refresh() {
        this.map.repaint();
    }

    @Override
    public void adjustScrollbars(Point upleft, Dimension size, Point min, Point max) {
        this.hbar.setValues(upleft.x, size.width, min.x, max.x);
        this.vbar.setValues(upleft.y, size.height, min.y, max.y);
    }

    @Override
    public void reportRoadInfo(Point square, int octant) {
        Junction j = this.myRealm.pToJ(square);
        String[] route = new String[2];
        String street = "";
        for (int i = 0; i < 2; ++i) {
            int rid = j.ridAt(octant, i);
            route[i] = rid > 0 ? "" + this.myRealm.routes[rid].getNumber() : "";
        }
        int sid = j.sidAt(octant);
        if (sid > 1) {
            street = this.myRealm.streetNames[sid];
        }
        this.myPathTool.reportRoadInfo(route, street, j.pavementAt(octant));
    }
}

