/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.Empire;
import com.kurumi.matr.Junction;
import com.kurumi.matr.MapFrame;
import com.kurumi.matr.MapUtils;
import com.kurumi.matr.MatrPanel;
import com.kurumi.matr.Realm;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class RoadMapCanvas
extends Canvas {
    private static int minMarkerClearance = 36;
    public static final int doNothing = 0;
    public static final int doCenter = 1;
    public static final int doCenterZoom = 2;
    public static final int doMoveViewer = 3;
    public static final int doPave = 4;
    public static String[] clickStrings = new String[]{"Nothing", "Center", "Zoom In", "Move Viewer", "Pave"};
    private int width = 0;
    private int height = 0;
    private Realm myRealm;
    private MapFrame myMapFrame;
    private MatrPanel myPanel;
    private int cvNum = 2;
    private int cvDenom = 1;
    private Point upleft = new Point(0, 0);
    private boolean firstPaint = true;
    private Rectangle viewport;
    private Rectangle fullViewPort;
    private Rectangle landViewPort;
    private Vector<Point> selection = new Vector();
    private static Point zeroPoint = new Point(0, 0);
    private int clickAction = 2;

    RoadMapCanvas(Realm realm, MatrPanel panel, MapFrame frame) {
        this.myRealm = realm;
        this.myPanel = panel;
        this.myMapFrame = frame;
        this.width = this.myRealm.getWidth();
        this.height = this.myRealm.getHeight();
        this.fullViewPort = new Rectangle(0, 0, this.width, this.height);
        this.landViewPort = new Rectangle(0, 0, this.width, this.height);
        this.landViewPort.grow(-1, -1);
        this.setBackground(Color.white);
        MapUtils.setMarkerColor(2, MapUtils.highwayColor);
    }

    private int sqToXPixel(int sq) {
        return sq * this.cvNum / this.cvDenom - this.upleft.x;
    }

    private int sqToXMidPixel(int sq) {
        return sq * this.cvNum / this.cvDenom + this.cvNum / (this.cvDenom * 2) - this.upleft.x;
    }

    private int sqToYPixel(int sq) {
        return sq * this.cvNum / this.cvDenom - this.upleft.y;
    }

    private int sqToYMidPixel(int sq) {
        return sq * this.cvNum / this.cvDenom + this.cvNum / (this.cvDenom * 2) - this.upleft.y;
    }

    private int pixelToXSq(int pixel) {
        return (pixel + this.upleft.x) * this.cvDenom / this.cvNum;
    }

    private int pixelToYSq(int pixel) {
        return (pixel + this.upleft.y) * this.cvDenom / this.cvNum;
    }

    private boolean isPixelOnMap(int x, int y) {
        int xp = this.pixelToXSq(x);
        int yp = this.pixelToYSq(y);
        return xp >= 0 && xp < this.width && yp >= 0 && yp < this.height;
    }

    private int pixelToPointAndOctant(Point mouse, Point square) {
        boolean above4;
        square.x = this.pixelToXSq(mouse.x);
        square.y = this.pixelToYSq(mouse.y);
        int d = this.cvNum / this.cvDenom;
        int dx = mouse.x - this.sqToXPixel(square.x);
        int dy = mouse.y - this.sqToYPixel(square.y);
        boolean above1 = dy > -d / 2 + 2 * dx;
        boolean above2 = dy > d / 4 + dx / 2;
        boolean above3 = dy > 3 * d / 4 - dx / 2;
        boolean bl = above4 = dy > 3 * d / 2 - 2 * dx;
        if (!above1 && !above4) {
            return 0;
        }
        if (above1 && !above2) {
            return 7;
        }
        if (above2 && !above3) {
            return 6;
        }
        if (above3 && !above4) {
            return 5;
        }
        if (above4 && above1) {
            return 4;
        }
        if (!above1 && above2) {
            return 3;
        }
        if (!above2 && above3) {
            return 2;
        }
        if (!above3 && above4) {
            return 1;
        }
        return 0;
    }

    Rectangle viewableRect() {
        return new Rectangle(this.pixelToXSq(0), this.pixelToYSq(0), this.pixelToXSq(this.getSize().width), this.pixelToYSq(this.getSize().height));
    }

    void setViewableRect() {
        this.viewport = this.viewableRect();
    }

    public void deselect() {
        this.selection.setSize(0);
        this.repaint();
    }

    public Vector<Point> getSelection() {
        return this.selection;
    }

    private static int sign(int left, int right) {
        if (left >= right) {
            return left == right ? 0 : 1;
        }
        return -1;
    }

    void extendSelection(int mx, int my) {
        int sy;
        Point tileClicked = new Point(mx, my);
        if (this.selection.size() == 0) {
            this.selection.addElement(tileClicked);
            return;
        }
        int matchIndex = this.selection.indexOf(tileClicked);
        if (matchIndex >= 0) {
            this.selection.setSize(matchIndex + 1);
            return;
        }
        Point pathEnd = this.selection.lastElement();
        int sx = pathEnd.x;
        if (this.selection.size() >= 2) {
            Point penult = this.selection.elementAt(this.selection.size() - 2);
            if (penult.x != sx && penult.y != sy && sx - penult.x == RoadMapCanvas.sign(mx, sx) && sy - penult.y == RoadMapCanvas.sign(my, sy)) {
                for (sy = pathEnd.y; sx != mx && sy != my; sx += RoadMapCanvas.sign(mx, sx), sy += RoadMapCanvas.sign(my, sy)) {
                    this.selection.addElement(new Point(sx, sy));
                }
            }
        }
        while (Math.abs(mx - sx) != Math.abs(my - sy)) {
            if (Math.abs(mx - sx) > Math.abs(my - sy)) {
                sx += RoadMapCanvas.sign(mx, sx);
            } else {
                sy += RoadMapCanvas.sign(my, sy);
            }
            this.selection.addElement(new Point(sx, sy));
        }
        while (sx != mx) {
            sx += RoadMapCanvas.sign(mx, sx);
            sy += RoadMapCanvas.sign(my, sy);
            this.selection.addElement(new Point(sx, sy));
        }
    }

    private void drawSelection(Graphics g) {
        if (this.selection.size() < 1) {
            return;
        }
        g.setColor(MapUtils.selectionColor);
        Point pp = this.selection.elementAt(0);
        int x0 = this.sqToXMidPixel(pp.x);
        int y0 = this.sqToYMidPixel(pp.y);
        g.drawOval(x0 - 3, y0 - 3, 6, 6);
        if (this.selection.size() == 1) {
            return;
        }
        for (int i = 0; i < this.selection.size() - 1; ++i) {
            Point from = this.selection.elementAt(i);
            Point to = this.selection.elementAt(i + 1);
            x0 = this.sqToXMidPixel(from.x);
            y0 = this.sqToYMidPixel(from.y);
            int x1 = this.sqToXMidPixel(to.x);
            int y1 = this.sqToYMidPixel(to.y);
            g.drawLine(x0 + 1, y0 - 1, x1 + 1, y1 - 1);
            g.drawLine(x0 - 1, y0 - 1, x1 - 1, y1 - 1);
            g.drawLine(x0, y0, x1, y1);
            g.drawLine(x0 + 1, y0 + 1, x1 + 1, y1 + 1);
            g.drawLine(x0 - 1, y0 + 1, x1 - 1, y1 + 1);
        }
    }

    private void drawWater(Graphics g) {
        g.setColor(MapUtils.oceanColor);
        Rectangle myRect = this.viewport.intersection(this.fullViewPort);
        for (int xx = myRect.x; xx < myRect.x + myRect.width; ++xx) {
            for (int yy = myRect.y; yy < myRect.y + myRect.height; ++yy) {
                if (this.myRealm.grid[xx][yy].getTerrain() != 0) continue;
                int x0 = this.sqToXPixel(xx);
                int x1 = this.sqToXPixel(xx + 1);
                int y0 = this.sqToYPixel(yy);
                int y1 = this.sqToYPixel(yy + 1);
                g.fillRect(x0, y0, x1 - x0, y1 - y0);
            }
        }
    }

    private void drawRouteMarkers(Graphics g) {
        int perSquare = this.cvNum / this.cvDenom;
        boolean wasVisible = false;
        int numRoutes = this.myRealm.getNumRoutes();
        for (int i = 1; i <= numRoutes; ++i) {
            boolean endOfRoute = false;
            Point start = new Point(this.myRealm.routes[i].getStart());
            Point half = new Point(start);
            wasVisible = this.viewport.contains(start.x, start.y);
            while (!endOfRoute) {
                int length = 0;
                while (true) {
                    if (!this.myRealm.nextJunc(start, i)) {
                        endOfRoute = true;
                        break;
                    }
                    if (!this.viewport.contains(start.x, start.y)) {
                        if (wasVisible) break;
                        continue;
                    }
                    if (!wasVisible) {
                        half.move(start.x, start.y);
                        length = 0;
                    } else {
                        ++length;
                    }
                    wasVisible = true;
                    if (wasVisible && this.myRealm.grid[start.x][start.y].getJunc().isRouteInflection()) break;
                    if ((length & 1) == 0) continue;
                    this.myRealm.nextJunc(half, i);
                }
                if (wasVisible && length * perSquare > minMarkerClearance) {
                    Junction jh = this.myRealm.grid[half.x][half.y].getJunc();
                    int mydir = jh.getForwardDirection(i);
                    int[] rids = jh.ridsAt(mydir);
                    if (length > 1) {
                        if (rids[1] > 0) {
                            if (rids[1] != i) {
                                this.drawMarker(g, half, rids);
                            }
                        } else {
                            this.drawMarker(g, half, i);
                        }
                    }
                    if (length == 1) {
                        if (rids[1] > 0) {
                            if (rids[1] != i) {
                                this.drawMarker(g, half, start, rids);
                            }
                        } else {
                            this.drawMarker(g, half, start, i);
                        }
                    }
                }
                half.move(start.x, start.y);
                wasVisible = this.viewport.contains(start.x, start.y);
            }
        }
    }

    void drawMarker(Graphics g, Point here, int rid) {
        int xc = this.sqToXMidPixel(here.x);
        int yc = this.sqToYMidPixel(here.y);
        MapUtils.drawMarker(g, xc, yc, this.myRealm.routes[rid].getNumber());
    }

    void drawMarker(Graphics g, Point here, Point next, int rid) {
        int xc = (this.sqToXMidPixel(here.x) + this.sqToXMidPixel(next.x)) / 2;
        int yc = (this.sqToYMidPixel(here.y) + this.sqToYMidPixel(next.y)) / 2;
        MapUtils.drawMarker(g, xc, yc, this.myRealm.routes[rid].getNumber());
    }

    void drawMarker(Graphics g, Point here, int[] rid) {
        int xc = this.sqToXMidPixel(here.x);
        int yc = this.sqToYMidPixel(here.y);
        int num0 = this.myRealm.routes[rid[0]].getNumber();
        int num1 = this.myRealm.routes[rid[1]].getNumber();
        MapUtils.drawMarker(g, xc, yc, num0, num1);
    }

    void drawMarker(Graphics g, Point here, Point next, int[] rid) {
        int xc = (this.sqToXMidPixel(here.x) + this.sqToXMidPixel(next.x)) / 2;
        int yc = (this.sqToYMidPixel(here.y) + this.sqToYMidPixel(next.y)) / 2;
        int num0 = this.myRealm.routes[rid[0]].getNumber();
        int num1 = this.myRealm.routes[rid[1]].getNumber();
        MapUtils.drawMarker(g, xc, yc, num0, num1);
    }

    private void drawTownBorders(Graphics g) {
        g.setColor(MapUtils.townLineColor);
        Rectangle myRect = this.viewport.intersection(this.landViewPort);
        for (int xx = myRect.x; xx < myRect.x + myRect.width; ++xx) {
            for (int yy = myRect.y; yy < myRect.y + myRect.height; ++yy) {
                int c3;
                int y0;
                int x0;
                int c1;
                int ch;
                if (this.myRealm.grid[xx][yy].getTerrain() == 0) continue;
                if (yy > 0 && this.myRealm.grid[xx][yy - 1].getTerrain() != 0 && (ch = this.myRealm.grid[xx][yy].getTown()) != (c1 = this.myRealm.grid[xx][yy - 1].getTown())) {
                    x0 = this.sqToXPixel(xx);
                    y0 = this.sqToYPixel(yy);
                    int x1 = this.sqToXPixel(xx + 1);
                    g.drawLine(x0, y0, x1, y0);
                }
                if (xx <= 0 || this.myRealm.grid[xx - 1][yy].getTerrain() == 0 || (ch = this.myRealm.grid[xx][yy].getTown()) == (c3 = this.myRealm.grid[xx - 1][yy].getTown())) continue;
                x0 = this.sqToXPixel(xx);
                y0 = this.sqToYPixel(yy);
                int y1 = this.sqToYPixel(yy + 1);
                g.drawLine(x0, y0, x0, y1);
            }
        }
    }

    private static void drawSeg(Graphics g, int paveType, boolean isRoute, int dir, int xc, int yc, int x1, int y1) {
        Color lineColor = MapUtils.streetColor;
        if (isRoute) {
            lineColor = MapUtils.highwayColor;
        }
        if (paveType == 1) {
            lineColor = MapUtils.dirtRoadColor;
        }
        boolean isDivided = Junction.isPaveTypeDivided(paveType);
        MapUtils.drawRoadSegment(g, lineColor, isDivided, dir, xc, yc, x1, y1);
    }

    private void drawRoads(Graphics g) {
        Rectangle myRect = this.viewport.intersection(this.landViewPort);
        for (int xx = myRect.x; xx < myRect.x + myRect.width; ++xx) {
            for (int yy = myRect.y; yy < myRect.y + myRect.height; ++yy) {
                int paveType;
                if (this.myRealm.grid[xx][yy].junc == null) continue;
                int x0 = this.sqToXPixel(xx);
                int y0 = this.sqToYPixel(yy);
                int x1 = this.sqToXPixel(xx + 1);
                int y1 = this.sqToYPixel(yy + 1);
                int xc = (x0 + x1) / 2;
                int yc = (y0 + y1) / 2;
                int[] dx = new int[]{xc, x1, x1, x1, xc, x0, x0, x0};
                int[] dy = new int[]{y0, y0, yc, y1, y1, y1, yc, y0};
                Junction j = this.myRealm.grid[xx][yy].junc;
                if (j.bridge == 0) {
                    int dir;
                    for (dir = 0; dir < 8; ++dir) {
                        paveType = j.pavementAt(dir);
                        if (paveType == 0 || Junction.isPaveTypeDivided(paveType)) continue;
                        RoadMapCanvas.drawSeg(g, paveType, !j.hasNoRoutes(dir), dir, xc, yc, dx[dir], dy[dir]);
                    }
                    for (dir = 0; dir < 8; ++dir) {
                        paveType = j.pavementAt(dir);
                        if (paveType == 0 || !Junction.isPaveTypeDivided(paveType)) continue;
                        RoadMapCanvas.drawSeg(g, paveType, !j.hasNoRoutes(dir), dir, xc, yc, dx[dir], dy[dir]);
                    }
                    continue;
                }
                int bdir = j.bridge - 1;
                for (int dir = 0; dir < 8; ++dir) {
                    if (dir % 4 == bdir || (paveType = j.pavementAt(dir)) == 0) continue;
                    RoadMapCanvas.drawSeg(g, paveType, !j.hasNoRoutes(dir), dir, xc, yc, dx[dir], dy[dir]);
                }
                boolean divided = j.isDivided(bdir) || j.isDivided(Junction.getReverseDirection(bdir));
                MapUtils.drawGradeSeps(g, bdir, xc, yc, divided);
                for (int dir = 0; dir < 8; ++dir) {
                    if (dir % 4 != bdir || (paveType = j.pavementAt(dir)) == 0) continue;
                    RoadMapCanvas.drawSeg(g, paveType, !j.hasNoRoutes(dir), dir, xc, yc, dx[dir], dy[dir]);
                }
            }
        }
    }

    private void drawTownNames(Graphics g) {
        g.setFont(Empire.townFont);
        g.setColor(MapUtils.townNameColor);
        for (int i = 1; i <= this.myRealm.getNumTowns(); ++i) {
            int xt = this.sqToXMidPixel(this.myRealm.towns[i].getCenter().x);
            int yt = this.sqToYMidPixel(this.myRealm.towns[i].getCenter().y);
            g.drawOval(xt - 2, yt - 2, 4, 4);
            g.drawString(this.myRealm.towns[i].getName(), xt + 5, yt);
        }
    }

    public void updatex(int x) {
        this.upleft.move(x, this.upleft.y);
        this.repaint();
        this.setViewableRect();
    }

    public void updatey(int y) {
        this.upleft.move(this.upleft.x, y);
        this.repaint();
        this.setViewableRect();
    }

    public void zoomToFit() {
        int viewWidth = this.getSize().width;
        int viewHeight = this.getSize().height;
        if (viewWidth * this.height < viewHeight * this.width) {
            this.cvNum = viewWidth;
            this.cvDenom = this.width;
        } else {
            this.cvNum = viewHeight;
            this.cvDenom = this.height;
        }
        this.upleft.y = 0;
        this.upleft.x = 0;
        this.adjustScrollbars();
        this.setViewableRect();
    }

    public int pixWidth() {
        return this.width * this.cvNum / this.cvDenom;
    }

    public int pixHeight() {
        return this.height * this.cvNum / this.cvDenom;
    }

    public void zoomIn() {
        if (this.cvDenom % 2 == 0) {
            this.cvDenom /= 2;
        } else {
            this.cvNum *= 2;
        }
        int cx = this.upleft.x + this.getSize().width / 2;
        this.upleft.x = 2 * cx - this.getSize().width / 2;
        int cy = this.upleft.y + this.getSize().height / 2;
        this.upleft.y = 2 * cy - this.getSize().height / 2;
        this.adjustScrollbars();
        this.setViewableRect();
    }

    public void zoomOut() {
        if (this.cvNum % 2 == 0) {
            this.cvNum /= 2;
        } else {
            this.cvDenom *= 2;
        }
        int cx = this.upleft.x + this.getSize().width / 2;
        this.upleft.x = cx / 2 - this.getSize().width / 2;
        int cy = this.upleft.y + this.getSize().height / 2;
        this.upleft.y = cy / 2 - this.getSize().height / 2;
        this.adjustScrollbars();
        this.setViewableRect();
    }

    public void centerAt(int cx, int cy) {
        this.upleft.x = cx - this.getSize().width / 2;
        this.upleft.y = cy - this.getSize().height / 2;
        this.adjustScrollbars();
        this.setViewableRect();
    }

    public void centerAndZoomInAt(int cx, int cy) {
        int rcx = this.getSize().width / 2;
        int rcy = this.getSize().height / 2;
        this.upleft.x += cx - rcx;
        this.upleft.y += cy - rcy;
        this.zoomIn();
    }

    private void getRoadInfo(int x, int y) {
        Point square = new Point();
        int octant = this.pixelToPointAndOctant(new Point(x, y), square);
        if (this.myRealm.grid[square.x][square.y].getTerrain() != 0) {
            this.myMapFrame.reportRoadInfo(square, octant);
            this.myPanel.infoCopiedFromMap(square, octant);
        }
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        this.adjustScrollbars();
        this.setViewableRect();
    }

    public void adjustScrollbars() {
        this.myMapFrame.adjustScrollbars(this.upleft, this.getSize(), zeroPoint, new Point(this.pixWidth(), this.pixHeight()));
    }

    private void tempSetBridge(int x, int y) {
        int xx = this.pixelToXSq(x);
        int yy = this.pixelToYSq(y);
        Junction j = this.myRealm.grid[xx][yy].junc;
        if (j == null) {
            return;
        }
        j.bridge = (short)(j.bridge + 1);
        if (j.bridge > 4) {
            j.bridge = 0;
        }
        this.repaint();
    }

    @Override
    public boolean mouseUp(Event e, int x, int y) {
        if (this.clickAction == 4 && (e.modifiers & 1) != 0) {
            this.tempSetBridge(x, y);
            return true;
        }
        if (!this.isPixelOnMap(x, y)) {
            return true;
        }
        if ((e.modifiers & 4) != 0) {
            this.getRoadInfo(x, y);
            return true;
        }
        switch (this.clickAction) {
            case 0: {
                break;
            }
            case 1: {
                this.centerAt(x, y);
                this.repaint();
                break;
            }
            case 2: {
                this.centerAndZoomInAt(x, y);
                this.repaint();
                break;
            }
            case 3: {
                this.myPanel.setPlayerLocation(this.pixelToXSq(x), this.pixelToYSq(y));
                break;
            }
            case 4: {
                this.extendSelection(this.pixelToXSq(x), this.pixelToYSq(y));
                this.repaint();
            }
        }
        return true;
    }

    public void setClickAction(int what) {
        this.clickAction = what;
    }

    @Override
    public void paint(Graphics g) {
        if (this.firstPaint) {
            this.firstPaint = false;
            this.zoomToFit();
        }
        this.drawSelection(g);
        this.drawWater(g);
        this.drawTownBorders(g);
        this.drawRoads(g);
        this.drawRouteMarkers(g);
        this.drawTownNames(g);
    }
}

