/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.EName;
import com.kurumi.matr.Junction;
import com.kurumi.matr.Route;
import com.kurumi.matr.Square;
import com.kurumi.matr.Town;
import java.awt.Point;
import java.util.Random;

public class Realm {
    private static final int landIndent = 4;
    private static final int maxTowns = 128;
    private static final int maxStreets = 1023;
    private static final int maxRoutes = 1023;
    private static final int numRuralRoads = 10;
    private static final int oddsMask = 15;
    private static final int eat9x9odds = 5;
    private static final int change3x3odds = 5;
    private static final int fixSlabOdds = 7;
    private static final int persistence = 10;
    private static final int streetpersistence = 8;
    private static final int doubleup = 12;
    private static final int changeDirBias = 3;
    private static final int returnToNaturalDirBias = 6;
    private static final int minLengthPersist = 8;
    private static final int minLengthStreetPersist = 6;
    private static final int minLengthBeforeRemeetRoute = 12;
    private static final int minLengthAtDirBias = 12;
    private static final int rcStreet = 0;
    private static final int rcRoute = 1;
    Square[][] grid;
    EName namer = new EName();
    Town[] towns = new Town[128];
    String[] streetNames = new String[1023];
    Route[] routes = new Route[1023];
    int[] topTowns = new int[100];
    int[] leftTowns = new int[100];
    private Random dice = new Random();
    private int width;
    private int height;
    private int numTowns;
    private int numOpenSquares = 1;
    private int numRoutes;
    private int numSids = 0;
    int lengthAtDirBias;
    int currentDirBias;
    int naturalDirBias;

    Realm(int width_, int height_, int numRoutes_) {
        this.width = width_;
        this.height = height_;
        this.numRoutes = numRoutes_;
        this.grid = new Square[this.width][this.height];
        for (int i = this.width - 1; i >= 0; --i) {
            for (int j = this.height - 1; j >= 0; --j) {
                this.grid[i][j] = new Square();
            }
        }
    }

    public void create() {
        this.makeCoastline();
        this.fillTowns();
        this.MakePaths();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumTowns() {
        return this.numTowns;
    }

    public int getNumRoutes() {
        return this.numRoutes;
    }

    private void clearMarks() {
        for (int i = this.width - 1; i >= 0; --i) {
            for (int j = this.height - 1; j >= 0; --j) {
                this.grid[i][j].setMarked(false);
            }
        }
    }

    private void fillTerrain(int x0, int y0, int w, int h, int terr) {
        for (int x = x0; x < x0 + w; ++x) {
            for (int y = y0; y < y0 + h; ++y) {
                this.grid[x][y].setTerrain(terr);
            }
        }
    }

    private void do3x3vert(int x, int y) {
        int down;
        int up = this.grid[x][y - 1].getTerrain();
        if (up != (down = this.grid[x][y].getTerrain())) {
            int chance = this.dice.nextInt() & 0xF;
            if (chance < 5) {
                this.fillTerrain(x, y, 3, 3, up);
            } else if (chance < 10) {
                this.fillTerrain(x, y - 3, 3, 3, down);
            }
        }
    }

    private void do3x3horiz(int x, int y) {
        int right;
        int left = this.grid[x - 1][y].getTerrain();
        if (left != (right = this.grid[x][y].getTerrain())) {
            int chance = this.dice.nextInt() & 0xF;
            if (chance < 5) {
                this.fillTerrain(x, y, 3, 3, left);
            } else if (chance < 10) {
                this.fillTerrain(x - 3, y, 3, 3, right);
            }
        }
    }

    private void do3x3block(int x, int y) {
        this.do3x3vert(x + 3, y);
        this.do3x3vert(x + 3, y + 9);
        this.do3x3horiz(x, y + 3);
        this.do3x3horiz(x + 9, y + 3);
    }

    private void fixslab(int x, int y) {
        if ((this.dice.nextInt() & 0xF) >= 7) {
            return;
        }
        int numWater = 0;
        int me = this.grid[x][y].getTerrain();
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                if (this.grid[i][j].getTerrain() != 0) continue;
                ++numWater;
            }
        }
        if (numWater == 4 && me == 0) {
            this.grid[x][y].setTerrain(1);
        }
        if (numWater == 5 && me == 1) {
            this.grid[x][y].setTerrain(0);
        }
    }

    void makeCoastline() {
        int y;
        int x;
        this.fillTerrain(4, 4, this.width - 8, this.height - 8, 1);
        for (x = 4; x < this.width - 4 - 9; x += 9) {
            if ((this.dice.nextInt() & 0xF) < 5) {
                this.fillTerrain(x, 4, 9, 9, 0);
            }
            if ((this.dice.nextInt() & 0xF) >= 5) continue;
            this.fillTerrain(x, this.height - 4 - 9, 9, 9, 0);
        }
        for (y = 13; y < this.height - 4 - 18; y += 9) {
            if ((this.dice.nextInt() & 0xF) < 5) {
                this.fillTerrain(4, y, 9, 9, 0);
            }
            if ((this.dice.nextInt() & 0xF) >= 5) continue;
            this.fillTerrain(this.width - 4 - 9, y, 9, 9, 0);
        }
        for (x = 4; x < this.width - 4 - 9; x += 9) {
            this.do3x3block(x, 4);
            this.do3x3block(x, this.height - 4 - 9);
        }
        for (y = 13; y < this.height - 4 - 18; y += 9) {
            this.do3x3block(4, y);
            this.do3x3block(this.width - 4 - 9, y);
        }
        for (x = 0; x < this.width - 1; ++x) {
            for (int y2 = 0; y2 < this.height - 1; ++y2) {
                if (x > 0 && y2 > 0) {
                    this.fixslab(x, y2);
                }
                int ul = this.grid[x][y2].getTerrain();
                int ur = this.grid[x + 1][y2].getTerrain();
                int ll = this.grid[x][y2 + 1].getTerrain();
                int lr = this.grid[x + 1][y2 + 1].getTerrain();
                if (ul != lr || ur != ll || ul == ur) continue;
                this.fillTerrain(x, y2, 2, 2, 1);
            }
        }
    }

    void clearMarksAndCountOpen() {
        this.numOpenSquares = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.grid[x][y].setMarked(false);
                if (!this.grid[x][y].okForTown()) continue;
                ++this.numOpenSquares;
            }
        }
    }

    int adjRegion(int x, int y) {
        int[] cr = new int[]{0, 0, 0, 0};
        int numFound = 0;
        if (this.grid[x][y - 1].hasRealTown()) {
            cr[numFound++] = this.grid[x][y - 1].getTown();
        }
        if (this.grid[x + 1][y].hasRealTown()) {
            cr[numFound++] = this.grid[x + 1][y].getTown();
        }
        if (this.grid[x][y + 1].hasRealTown()) {
            cr[numFound++] = this.grid[x][y + 1].getTown();
        }
        if (this.grid[x - 1][y].hasRealTown()) {
            cr[numFound++] = this.grid[x - 1][y].getTown();
        }
        if (numFound > 0) {
            return cr[(this.dice.nextInt() & 3) % numFound];
        }
        return 0;
    }

    void checkNotch(int x, int y) {
        if (!(this.grid[x][y - 1].hasRealTown() && this.grid[x + 1][y].hasRealTown() && this.grid[x][y + 1].hasRealTown() && this.grid[x - 1][y].hasRealTown())) {
            return;
        }
        int tNorth = this.grid[x][y - 1].getTown();
        int tEast = this.grid[x + 1][y].getTown();
        int tSouth = this.grid[x][y + 1].getTown();
        int tWest = this.grid[x - 1][y].getTown();
        if (tNorth == tEast && (tEast == tSouth || tEast == tWest)) {
            this.grid[x][y].setTown(tNorth);
        }
        if (tNorth == tSouth && tSouth == tWest) {
            this.grid[x][y].setTown(tNorth);
        }
        if (tEast == tSouth && tSouth == tWest) {
            this.grid[x][y].setTown(tEast);
        }
    }

    int surfaceArea() {
        int total = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.grid[x][y].getTerrain() == 0) continue;
                ++total;
            }
        }
        return total;
    }

    void calculateTownCenters() {
        int i;
        Point[] sums = new Point[this.numTowns + 1];
        for (i = 1; i <= this.numTowns; ++i) {
            sums[i] = new Point(0, 0);
            this.towns[i].setArea(0);
        }
        for (int xx = 0; xx < this.width; ++xx) {
            for (int yy = 0; yy < this.height; ++yy) {
                int myTown = this.grid[xx][yy].getTown();
                if (myTown <= 0) continue;
                this.towns[myTown].incrementArea();
                sums[myTown].x += xx;
                sums[myTown].y += yy;
            }
        }
        for (i = 1; i <= this.numTowns; ++i) {
            int xt = 0;
            int yt = 0;
            if (this.towns[i].getArea() > 0) {
                xt = sums[i].x / this.towns[i].getArea();
                yt = sums[i].y / this.towns[i].getArea();
            }
            while (this.grid[xt][yt].getTerrain() == 0) {
                xt = xt > this.width / 2 ? --xt : ++xt;
                if (yt > this.height / 2) {
                    --yt;
                    continue;
                }
                ++yt;
            }
            this.towns[i].setCenter(xt, yt);
        }
    }

    int townCenterAt(Point p) {
        for (int i = 1; i <= this.numTowns; ++i) {
            if (!p.equals(this.towns[i].getCenter())) continue;
            return i;
        }
        return 0;
    }

    void fillTowns() {
        int x;
        int y;
        int myWidth;
        int myHeight;
        int ntowns = this.surfaceArea() / 300;
        int nrows = (int)Math.round(Math.sqrt(ntowns * (myHeight = this.height - 8) / (myWidth = this.width - 8)));
        if (nrows < 1) {
            nrows = 1;
        }
        int thisId = 0;
        int ncused = 0;
        int nrused = 0;
        for (int r = 0; r < nrows; ++r) {
            int ty = myHeight / nrows * r + myHeight / nrows / 2 + 4;
            int ncols = Math.round((ntowns - ncused) / (nrows - nrused));
            for (int c = 0; c < ncols; ++c) {
                boolean createNewTown = false;
                int tx = myWidth / ncols * c + myWidth / ncols / 2 + 4;
                for (int i = 0; i < 14; ++i) {
                    if (this.grid[tx][ty].okForTown()) {
                        this.grid[tx][ty].setTown(thisId + 1);
                        createNewTown = true;
                    }
                    switch (this.dice.nextInt() & 3) {
                        case 0: {
                            --ty;
                            break;
                        }
                        case 1: {
                            ++tx;
                            break;
                        }
                        case 2: {
                            ++ty;
                            break;
                        }
                        case 3: {
                            --tx;
                        }
                    }
                    if (tx < 1) {
                        tx = 1;
                    }
                    if (tx > myWidth - 2) {
                        tx = myWidth - 2;
                    }
                    if (ty < 1) {
                        ty = 1;
                    }
                    if (ty <= myHeight - 2) continue;
                    ty = myHeight - 2;
                }
                if (createNewTown) {
                    this.towns[++thisId] = new Town(this.namer.pickNewTownName());
                    if (nrused == 0) {
                        this.topTowns[ncused] = thisId;
                    }
                    if (c == 0) {
                        this.leftTowns[nrused] = thisId;
                    }
                }
                ++ncused;
            }
            ++nrused;
        }
        this.numTowns = thisId;
        int npasses = 15;
        for (int i = 0; i < npasses; ++i) {
            for (y = 1; y < this.height - 1; ++y) {
                for (x = 1; x < this.width - 1; ++x) {
                    if ((this.dice.nextInt() & 0xF) >= 12 || !this.grid[x][y].okForTown()) continue;
                    this.grid[x][y].setTownAndMark(this.adjRegion(x, y));
                }
            }
            this.clearMarksAndCountOpen();
        }
        int oldNumOpenSquares = 0;
        while (this.numOpenSquares > 0) {
            for (y = 1; y < this.height - 1; ++y) {
                for (x = 1; x < this.width - 1; ++x) {
                    if (!this.grid[x][y].okForTown()) continue;
                    this.grid[x][y].setTownAndMark(this.adjRegion(x, y));
                }
            }
            this.clearMarksAndCountOpen();
            if (this.numOpenSquares == oldNumOpenSquares) break;
            oldNumOpenSquares = this.numOpenSquares;
        }
        for (y = 1; y < this.height - 1; ++y) {
            for (x = 1; x < this.width - 1; ++x) {
                this.checkNotch(x, y);
            }
        }
        this.calculateTownCenters();
    }

    public final Junction pToJ(Point p) {
        return this.grid[p.x][p.y].getJunc();
    }

    boolean prevJunc(Point here, int routeId) {
        int dir = this.pToJ(here).getBackwardDirectionStrict(routeId);
        if (dir >= 0) {
            Junction.move(here, dir);
            return true;
        }
        return false;
    }

    boolean nextJunc(Point here, int routeId) {
        int dir = this.pToJ(here).getForwardDirectionStrict(routeId);
        if (dir >= 0) {
            Junction.move(here, dir);
            return true;
        }
        return false;
    }

    void findRouteStart(int rid) {
        for (int y = 1; y < this.height - 1; ++y) {
            for (int x = 1; x < this.width - 1; ++x) {
                if (this.grid[x][y].junc == null || !this.grid[x][y].junc.isRouteStart(rid)) continue;
                this.routes[rid].setStart(x, y);
                return;
            }
        }
    }

    void findRouteEnd(int rid) {
        for (int y = 1; y < this.height - 1; ++y) {
            for (int x = 1; x < this.width - 1; ++x) {
                if (this.grid[x][y].junc == null || !this.grid[x][y].junc.isRouteEnd(rid)) continue;
                this.routes[rid].setEnd(x, y);
                return;
            }
        }
    }

    int routeLength(Point start, int rid) {
        int length = 0;
        Point here = new Point(start);
        while (this.nextJunc(here, rid)) {
            ++length;
        }
        return length;
    }

    boolean cantPave(Junction j, Point p, int heading) {
        if (this.grid[p.x][p.y].getTerrain() == 0) {
            return true;
        }
        if (!j.isSuitableForLeg(heading)) {
            return true;
        }
        Point nextp = new Point(p);
        Junction.move(nextp, heading);
        if (nextp.x < 0 || nextp.y < 0 || nextp.x >= this.width || nextp.y >= this.height) {
            return true;
        }
        if (this.grid[nextp.x][nextp.y].getTerrain() == 0) {
            return true;
        }
        if (!this.pToJ(nextp).isSuitableForLeg(Junction.getReverseDirection(heading))) {
            return true;
        }
        if (Junction.isDiagonal(heading)) {
            nextp.setLocation(p);
            Junction.move(nextp, heading, 7);
            if (!this.pToJ(nextp).isEmpty(heading, 2)) {
                return true;
            }
            nextp.setLocation(p);
            Junction.move(nextp, heading, 1);
            if (!this.pToJ(nextp).isEmpty(heading, 6)) {
                return true;
            }
        }
        return false;
    }

    boolean cantPave(Point p, int heading) {
        return this.cantPave(this.pToJ(p), p, heading);
    }

    boolean cantAddRoute(Junction j, Point p, int direction) {
        if (this.cantPave(j, p, direction)) {
            return true;
        }
        return j.isFull(direction);
    }

    boolean cantAddStreet(Junction j, Point p, int direction) {
        if (this.cantPave(j, p, direction)) {
            return true;
        }
        return !j.isEmpty(direction);
    }

    boolean pickPavementStart(Point here, int heading) {
        int delta = this.dice.nextInt(Integer.MAX_VALUE) % (2 * this.width / 3);
        switch (heading) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                here.x = delta;
                break;
            }
            default: {
                here.x = this.width - 1 - delta;
            }
        }
        delta = this.dice.nextInt(Integer.MAX_VALUE) % (2 * this.height / 3);
        switch (heading) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                here.y = delta;
                break;
            }
            default: {
                here.y = this.height - 1 - delta;
            }
        }
        return !this.cantPave(this.pToJ(here), here, heading);
    }

    void pickRouteStart(Point here, int heading, boolean findExisting) {
        int maxTries = 200;
        while (true) {
            if (this.pickPavementStart(here, heading)) {
                Junction j = this.pToJ(here);
                if (findExisting || maxTries <= 0 ? j.isTwoWay() && j.isEmpty(heading) : j.hasNoRoutes(heading) && j.isSuitableForLeg(heading)) {
                    return;
                }
            }
            --maxTries;
        }
    }

    void pickStreetStart(Point here, int heading, boolean findExisting) {
        int maxTries = 200;
        Junction j;
        while (!(this.pickPavementStart(here, heading) && (j = this.pToJ(here)).isEmpty(heading) && (findExisting || maxTries <= 0 ? j.isTwoWay() : j.isSuitableForLeg(heading)))) {
            --maxTries;
        }
        return;
    }

    void addRouteBoth(Point here, int heading, int rid, int paveType, boolean forward) {
        Point next = new Point(here);
        Junction.move(next, heading);
        int reverse = Junction.getReverseDirection(heading);
        this.pToJ(here).setWiderPavement(heading, paveType);
        this.pToJ(next).setWiderPavement(reverse, paveType);
        this.addRidBoth(here, heading, rid, forward);
    }

    void addRidBoth(Point here, int heading, int rid, boolean forward) {
        Point next = new Point(here);
        Junction.move(next, heading);
        if (forward) {
            this.pToJ(here).addRidForward(heading, rid);
            this.pToJ(next).addRidBack(heading, rid);
        } else {
            int flipheading = Junction.getReverseDirection(heading);
            this.pToJ(here).addRidBack(flipheading, rid);
            this.pToJ(next).addRidForward(flipheading, rid);
        }
    }

    void removeRidBoth(Point here, int heading, int rid) {
        Point next = new Point(here);
        Junction.move(next, heading);
        this.pToJ(here).removeRid(heading, rid);
        this.pToJ(next).removeRid(Junction.getReverseDirection(heading), rid);
    }

    void clearRidsBoth(Point here, int heading) {
        Point next = new Point(here);
        Junction.move(next, heading);
        this.pToJ(here).clearRids(heading);
        this.pToJ(next).clearRids(Junction.getReverseDirection(heading));
    }

    void addStreetBoth(Point here, int heading, int sid, int paveType, boolean forward) {
        Point next = new Point(here);
        Junction.move(next, heading);
        if (forward) {
            this.pToJ(here).addStreetForward(heading, sid, paveType);
            this.pToJ(next).addStreetBack(heading, sid, paveType);
        } else {
            int flipheading = Junction.getReverseDirection(heading);
            this.pToJ(here).addStreetBack(flipheading, sid, paveType);
            this.pToJ(next).addStreetForward(flipheading, sid, paveType);
        }
    }

    void setSidBoth(Point here, int heading, int sid) {
        Point next = new Point(here);
        Junction.move(next, heading);
        this.pToJ(here).setStreetId(heading, sid, true);
        this.pToJ(next).setStreetId(Junction.getReverseDirection(heading), sid, true);
    }

    void setPaveBoth(Point here, int heading, int paveType) {
        Point next = new Point(here);
        Junction.move(next, heading);
        this.pToJ(here).setPavement(heading, paveType);
        this.pToJ(next).setPavement(Junction.getReverseDirection(heading), paveType);
    }

    void initDirBias() {
        this.currentDirBias = 0;
        this.lengthAtDirBias = 0;
        int bc = this.dice.nextInt() & 0xF;
        this.naturalDirBias = bc < 3 ? -1 : (bc > 12 ? 1 : 0);
    }

    void checkDirBias() {
        int chance;
        ++this.lengthAtDirBias;
        if (this.lengthAtDirBias > 12 && (chance = this.dice.nextInt() & 0xF) < 3) {
            chance = this.dice.nextInt() & 0xF;
            this.currentDirBias = chance < 6 ? this.naturalDirBias : chance % 3 - 1;
            this.lengthAtDirBias = 0;
        }
    }

    void checkTurns(int[] dir, int[] dirChances, int oldHeading, boolean keepStraight) {
        for (int i = 0; i < dir.length; ++i) {
            if (keepStraight && dir[i] != oldHeading) {
                dirChances[i] = 0;
                continue;
            }
            int degTurn = Math.abs(oldHeading - dir[i]) * 45;
            if (degTurn > 90) {
                dirChances[i] = 0;
                continue;
            }
            if (degTurn != 90) continue;
            int n = i;
            dirChances[n] = dirChances[n] / 2;
        }
    }

    Point layout(int id, int roadClass, Point start, int heading, int paveType, int maxLength, boolean forward, boolean dieSoon, boolean keepStraight) {
        boolean done = false;
        boolean doubling = false;
        int numForcedDirections = 0;
        int length = 0;
        Point here = new Point(start);
        Point next = new Point();
        int lastIdSeen = 0;
        int sqSinceLastId = 0;
        if (!forward) {
            heading = Junction.getReverseDirection(heading);
        }
        int[] dir = new int[]{0, 0, 0, 0, 0};
        for (int i = 0; i < dir.length; ++i) {
            dir[i] = Junction.getGlobalDirection(heading, i - 2);
        }
        this.initDirBias();
        while (!done) {
            int i;
            int minPersist;
            Junction j = this.pToJ(here);
            int oldHeading = heading;
            boolean isIntersection = roadClass == 1 && !doubling && j.isRouteJunction() || roadClass == 0 && j.isThreeWayOrMore();
            int n = minPersist = roadClass == 1 ? 8 : 6;
            if (isIntersection) {
                int anyOtherRid;
                if (dieSoon || length > minPersist && (this.dice.nextInt() & 0xF) > 10) break;
                if (roadClass == 1 && (anyOtherRid = j.anyRidExcept(id)) != 0) {
                    lastIdSeen = anyOtherRid;
                    sqSinceLastId = 0;
                }
            }
            int[] dirChances = new int[]{5, 10, 30, 10, 5};
            int n2 = 2 + this.currentDirBias;
            dirChances[n2] = dirChances[n2] + 20;
            this.checkDirBias();
            int sumChances = 0;
            boolean enc2 = false;
            this.checkTurns(dir, dirChances, oldHeading, keepStraight);
            for (i = 0; i < dir.length; ++i) {
                if (dirChances[i] == 0) continue;
                if (roadClass == 1 && this.cantAddRoute(j, here, dir[i])) {
                    dirChances[i] = 0;
                    continue;
                }
                if (roadClass == 0 && this.cantAddStreet(j, here, dir[i])) {
                    dirChances[i] = 0;
                    continue;
                }
                if (roadClass == 1 && !j.hasNoRoutes(dir[i])) {
                    if (length == 0) {
                        dirChances[i] = 0;
                        continue;
                    }
                    if (!doubling) {
                        if ((this.dice.nextInt() & 0xF) >= 12) {
                            dirChances[i] = 0;
                            continue;
                        }
                        int n3 = i;
                        dirChances[n3] = dirChances[n3] + 20;
                        enc2 = true;
                    }
                }
                if (length < 3 && i != 2) {
                    int n4 = i;
                    dirChances[n4] = dirChances[n4] / 2;
                }
                ++sumChances;
            }
            if (sumChances == 1) {
                if (++numForcedDirections > 5 && length > 15) {
                    done = true;
                    break;
                }
                if (dieSoon) {
                    done = true;
                    break;
                }
            }
            if (roadClass == 1) {
                for (i = 0; i < dir.length; ++i) {
                    if (dirChances[i] == 0) continue;
                    next.setLocation(here);
                    Junction.move(next, dir[i]);
                    Junction jn = this.pToJ(next);
                    if (doubling || enc2 || lastIdSeen == 0 || !jn.containsRoute(lastIdSeen) || sqSinceLastId >= 12) continue;
                    dirChances[i] = 0;
                }
            }
            int totalChances = 0;
            for (int i2 = 0; i2 < dir.length; ++i2) {
                totalChances += dirChances[i2];
            }
            if (totalChances == 0) {
                done = true;
                break;
            }
            int sample = this.dice.nextInt(Integer.MAX_VALUE) % totalChances;
            int binTotal = 0;
            for (int i3 = 0; i3 < dir.length; ++i3) {
                if (dirChances[i3] == 0 || sample >= (binTotal += dirChances[i3])) continue;
                heading = dir[i3];
                break;
            }
            boolean wasDoubling = doubling;
            if (roadClass == 1) {
                doubling = !j.hasNoRoutes(heading);
            }
            next.setLocation(here);
            Junction.move(next, heading);
            ++sqSinceLastId;
            if (roadClass == 1) {
                this.addRouteBoth(here, heading, id, paveType, forward);
            }
            if (roadClass == 0) {
                this.addStreetBoth(here, heading, id, paveType, forward);
            }
            here.setLocation(next);
            if (++length < maxLength) continue;
            break;
        }
        return here;
    }

    private Point layoutCityStreet(int sid, Point here, int dir, int len) {
        return this.layout(sid, 0, here, dir, 2, len, true, false, true);
    }

    private Point layoutRuralRoad(int sid, Point here, int dir, int len) {
        return this.layout(sid, 0, here, dir, 2, len, true, false, false);
    }

    void MakePaths() {
        int i;
        int heading;
        int i2;
        Point here = new Point();
        Point next = new Point();
        Point start = new Point();
        Point end = new Point();
        int currentSid = 0;
        int topTownId = 0;
        int leftTownId = 0;
        boolean[] townUsed = new boolean[this.numTowns + 1];
        for (i2 = 1; i2 <= this.numTowns; ++i2) {
            townUsed[i2] = false;
        }
        int pavementType = 2;
        for (i2 = 1; i2 <= this.numTowns; ++i2) {
            here.setLocation(this.towns[i2].getCenter());
            for (int j = 0; j <= 4; ++j) {
                next.x = here.x + j - 2;
                next.y = here.y + 2;
                this.layoutCityStreet(++currentSid, next, 0, 4);
                this.streetNames[currentSid] = this.namer.pickNewStreetName();
                next.x = here.x - 2;
                next.y = here.y + j - 2;
                this.layoutCityStreet(++currentSid, next, 2, 4);
                this.streetNames[currentSid] = this.namer.pickNewStreetName();
            }
        }
        Point notSet = new Point(0, 0);
        int routeCount = 1;
        while (routeCount <= this.numRoutes) {
            int pref;
            heading = Junction.getRandomDirection90();
            here.setLocation(notSet);
            if (routeCount % 2 != 0) {
                if (this.topTowns[topTownId] > 0) {
                    townUsed[this.topTowns[topTownId]] = true;
                    here.setLocation(this.towns[this.topTowns[topTownId++]].getCenter());
                    heading = 4;
                }
            } else if (this.leftTowns[leftTownId] > 0) {
                townUsed[this.leftTowns[leftTownId]] = true;
                here.setLocation(this.towns[this.leftTowns[leftTownId++]].getCenter());
                heading = 2;
            }
            if (here.equals(notSet)) {
                for (i = this.numTowns; i >= 1; --i) {
                    if (townUsed[i]) continue;
                    here.setLocation(this.towns[i].getCenter());
                    townUsed[i] = true;
                    break;
                }
            }
            if (here.equals(notSet)) {
                this.pickRouteStart(here, heading, true);
            }
            start.setLocation(here);
            end.setLocation(this.layout(routeCount, 1, here, heading, pavementType, 300, true, false, false));
            if (this.routeLength(start, routeCount) <= 0) continue;
            switch (heading) {
                case 0: 
                case 4: {
                    pref = 1;
                    break;
                }
                default: {
                    pref = 2;
                }
            }
            int routeNum = this.namer.pickNewNumber(pref);
            this.routes[routeCount] = new Route(routeCount, routeNum, heading, start, end);
            ++routeCount;
        }
        for (i = 1; i <= this.numRoutes; ++i) {
            here.setLocation(this.routes[i].getStart());
            heading = this.routes[i].getLogDirection();
            here = this.layout(i, 1, here, heading, pavementType, 300, false, true, false);
            this.routes[i].setStart(here);
        }
        for (i = 1; i <= 10; ++i) {
            heading = Junction.getRandomDirection90();
            this.pickStreetStart(here, heading, true);
            this.layoutRuralRoad(++currentSid, here, heading, 96);
            this.streetNames[currentSid] = this.namer.pickNewRuralStreetName();
        }
        this.numSids = currentSid;
    }

    void changeRoute(int oldNumber, int newNumber) {
        for (int i = 1; i <= this.numRoutes; ++i) {
            if (this.routes[i].getNumber() != oldNumber) continue;
            this.routes[i].setNumber(newNumber);
            return;
        }
    }

    void changeStreet(String old, String anew) {
        for (int i = 1; i <= this.numSids; ++i) {
            if (!this.streetNames[i].equalsIgnoreCase(old)) continue;
            this.streetNames[i] = new String(anew);
            return;
        }
    }

    void changeTown(String old, String anew) {
        for (int i = 1; i <= this.numTowns; ++i) {
            if (!this.towns[i].getName().equalsIgnoreCase(old)) continue;
            this.towns[i].setName(anew);
            return;
        }
    }

    public int getRouteId(int rNumber) {
        for (int i = 1; i <= this.getNumRoutes(); ++i) {
            if (this.routes[i].getNumber() != rNumber) continue;
            return i;
        }
        return 0;
    }

    public int getRouteIdOrCreate(int rNumber, Point here, int heading, int logHeading) {
        int rid = this.getRouteId(rNumber);
        if (rid == 0) {
            Point next = new Point(here);
            Junction.move(next, heading);
            this.routes[++this.numRoutes] = new Route(this.numRoutes, rNumber, logHeading, here, next);
            return this.numRoutes;
        }
        return rid;
    }

    public int getSId(String sName) {
        for (int i = 1; i <= this.numSids; ++i) {
            if (!this.streetNames[i].equalsIgnoreCase(sName)) continue;
            return i;
        }
        return 0;
    }

    public int getSIdOrCreate(String sName) {
        if (sName.length() == 0) {
            return 0;
        }
        int sid = this.getSId(sName);
        if (sid == 0) {
            this.streetNames[++this.numSids] = new String(sName);
            return this.numSids;
        }
        return sid;
    }

    public boolean routeExists(int rnum) {
        return this.getRouteId(rnum) > 0;
    }

    public boolean streetExists(String name) {
        return this.getSId(name) > 0;
    }

    public boolean townExists(String name) {
        for (Town town : this.towns) {
            if (!town.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    void dump() {
        for (int y = 0; y < this.height; ++y) {
            block5: for (int x = 0; x < this.width; ++x) {
                switch (this.grid[x][y].getTerrain()) {
                    case 0: {
                        System.out.print('.');
                        continue block5;
                    }
                    case 1: {
                        System.out.print((char)(48 + this.grid[x][y].getTown()));
                    }
                }
            }
            System.out.println("");
        }
        System.out.println("---------------");
    }
}

