/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.Junction;
import com.kurumi.matr.MatrPanel;
import com.kurumi.matr.MyTools;
import com.kurumi.matr.Realm;
import com.kurumi.matr.RoadMapCanvas;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.TextField;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JSeparator;

public class PathTool
extends JFrame {
    private static final int add = 0;
    private static final int subtract = 1;
    private static final int paveNew = 2;
    private Button bAdd = new Button("Add");
    private Button bSub = new Button("Remove");
    private Button bSet = new Button("Set");
    private Button bErase = new Button("Erase");
    private Button bPave = new Button("Pave");
    private Button bDeselect = new Button("Deselect");
    private Choice chPaveType = new Choice();
    private Label laMessage = new Label();
    private TextField[] tfRoute = new TextField[Junction.maxOverlappingRoutes];
    private Choice[] chDirection = new Choice[Junction.maxOverlappingRoutes];
    private TextField tfStreet = new TextField("", 15);
    private Realm myRealm;
    private RoadMapCanvas myMap;
    private MatrPanel myPanel;
    private GridBagLayout layout = new GridBagLayout();

    private void add(Component c, GridBagConstraints gbc) {
        this.layout.setConstraints(c, gbc);
        this.add(c);
    }

    public PathTool(Realm r, RoadMapCanvas m, MatrPanel mp) {
        super("Pave, Number and Name");
        int i;
        this.setDefaultCloseOperation(0);
        this.myRealm = r;
        this.myMap = m;
        this.myPanel = mp;
        this.setLayout(this.layout);
        for (i = 0; i < Junction.maxOverlappingRoutes; ++i) {
            this.tfRoute[i] = new TextField(4);
            this.chDirection[i] = new Choice();
            for (String s : Junction.dirStrings90) {
                this.chDirection[i].add(s);
            }
        }
        for (i = 1; i < Junction.paveStrings.length; ++i) {
            this.chPaveType.addItem(Junction.paveStrings[i]);
        }
        GridBagConstraints c1 = new GridBagConstraints();
        int row = 0;
        MyTools.setLeftNoFill(c1, 0, row);
        this.add((Component)new Label("Path:"), c1);
        MyTools.setLeftNoFill(c1, 1, row);
        c1.gridwidth = 2;
        this.add((Component)this.bDeselect, c1);
        MyTools.setAllWide(c1, ++row);
        this.add((Component)new JSeparator(0), c1);
        MyTools.setLeft(c1, 0, ++row);
        this.add((Component)new Label("Type:"), c1);
        MyTools.setRestOfRow(c1, 1, row);
        this.add((Component)this.chPaveType, c1);
        MyTools.setLeftNoFill(c1, 1, ++row);
        this.add((Component)this.bPave, c1);
        MyTools.setLeftNoFill(c1, 3, row);
        this.add((Component)this.bErase, c1);
        MyTools.setAllWide(c1, ++row);
        this.add((Component)new JSeparator(0), c1);
        MyTools.setLeft(c1, 0, ++row);
        this.add((Component)new Label("Route:"), c1);
        MyTools.setLeft(c1, 1, row);
        this.add((Component)this.tfRoute[0], c1);
        MyTools.setLeft(c1, 2, row);
        c1.fill = 0;
        c1.gridwidth = 0;
        this.add((Component)this.chDirection[0], c1);
        MyTools.setLeft(c1, 0, ++row);
        this.add((Component)new Label("Route:"), c1);
        MyTools.setLeft(c1, 1, row);
        this.add((Component)this.tfRoute[1], c1);
        MyTools.setLeft(c1, 2, row);
        c1.fill = 0;
        c1.gridwidth = 0;
        this.add((Component)this.chDirection[1], c1);
        MyTools.setLeft(c1, 0, ++row);
        this.add((Component)new Label("Street:"), c1);
        MyTools.setRestOfRow(c1, 1, row);
        this.add((Component)this.tfStreet, c1);
        MyTools.setLeftNoFill(c1, 1, ++row);
        this.add((Component)this.bAdd, c1);
        c1.gridx = -1;
        this.add((Component)this.bSet, c1);
        this.add((Component)this.bSub, c1);
        MyTools.setAllWide(c1, ++row);
        this.add((Component)new JSeparator(0), c1);
        MyTools.setAllWide(c1, ++row);
        MyTools.setLastRow(c1);
        this.add((Component)this.laMessage, c1);
        this.pack();
    }

    @Override
    public boolean action(Event e, Object o) {
        if (e.target == this.bDeselect) {
            this.myMap.deselect();
            return true;
        }
        if (e.target == this.bPave) {
            this.handlePave(false);
            return true;
        }
        if (e.target == this.bErase) {
            this.handlePave(true);
            return true;
        }
        if (e.target == this.bAdd) {
            this.handleName(0);
            return true;
        }
        if (e.target == this.bSub) {
            this.handleName(1);
            return true;
        }
        if (e.target == this.bSet) {
            this.handleName(2);
            return true;
        }
        return super.action(e, o);
    }

    void handlePave(boolean erase) {
        Vector<Point> v = this.myMap.getSelection();
        if (v.size() < 2) {
            this.errorMessage("Can't pave; no path");
            return;
        }
        int paveType = this.chPaveType.getSelectedIndex() + 1;
        for (int i = 0; i < v.size() - 1; ++i) {
            Point next;
            Point here = v.elementAt(i);
            int dir = Junction.getDirection(here, next = v.elementAt(i + 1));
            if (dir < 0) {
                this.errorMessage("Internal error: J.getDirection() < 0");
                if (i == 0) {
                    this.myPanel.askRefresh(7);
                }
                return;
            }
            if (erase) {
                this.myRealm.pToJ(here).clearLeg(dir);
                this.myRealm.pToJ(next).clearLeg(Junction.getReverseDirection(dir));
                continue;
            }
            if (this.myRealm.cantPave(here, dir)) {
                this.errorMessage("Couldn't pave completely (bad intersection)");
                if (i == 0) {
                    this.myPanel.askRefresh(7);
                }
                return;
            }
            this.myRealm.setPaveBoth(here, dir, paveType);
        }
        this.myPanel.askRefresh(7);
        this.clearErrorMessage();
    }

    private void errorMessage(String msg) {
        this.laMessage.setText(msg);
        this.validate();
    }

    private void clearErrorMessage() {
        this.errorMessage("");
    }

    void handleName(int nameAction) {
        int j;
        Point next;
        Vector<Point> v = this.myMap.getSelection();
        if (v.size() < 2) {
            this.errorMessage("Couldn't name or number; no path");
            return;
        }
        Point here = v.elementAt(0);
        int dir = Junction.getDirection(here, next = v.elementAt(1));
        if (dir < 0) {
            this.errorMessage("Internal error: J.getDirection() < 0");
            return;
        }
        int[] rid = new int[this.tfRoute.length];
        boolean[] isForward = new boolean[this.tfRoute.length];
        for (j = 0; j < this.tfRoute.length; ++j) {
            int routeNumber = 0;
            int specDir = -1;
            routeNumber = MyTools.atoi(this.tfRoute[j].getText());
            if (routeNumber <= 0) continue;
            if (nameAction == 1) {
                if (this.myRealm.getRouteId(routeNumber) > 0) continue;
                this.errorMessage("Can't subtract " + routeNumber + "; doesn't exist");
                return;
            }
            specDir = Junction.dirFromChoice4(this.chDirection[j].getSelectedIndex());
            if (specDir < 0) {
                this.errorMessage("Internal error: bad direction for " + routeNumber);
                return;
            }
            rid[j] = this.myRealm.getRouteIdOrCreate(routeNumber, here, dir, specDir);
            int logDir = this.myRealm.routes[rid[j]].getLogDirection();
            int revDir = Junction.getReverseDirection(logDir);
            if (specDir == logDir) {
                isForward[j] = true;
                continue;
            }
            if (specDir == revDir) {
                isForward[j] = false;
                continue;
            }
            this.errorMessage("Please specify " + Junction.dirStrings[logDir] + " or " + Junction.dirStrings[revDir] + " for route " + routeNumber);
            return;
        }
        block6: for (int i = 0; i < v.size() - 1; ++i) {
            here = v.elementAt(i);
            dir = Junction.getDirection(here, next = v.elementAt(i + 1));
            if (dir < 0) {
                this.errorMessage("Internal error: J.getDirection() < 0");
                if (i == 0) {
                    this.myPanel.askRefresh(7);
                }
                return;
            }
            switch (nameAction) {
                case 2: {
                    this.myRealm.clearRidsBoth(here, dir);
                }
                case 0: {
                    int j2;
                    for (j2 = 0; j2 < this.tfRoute.length; ++j2) {
                        if (rid[j2] <= 0) continue;
                        this.myRealm.addRidBoth(here, dir, rid[j2], isForward[j2]);
                    }
                    continue block6;
                }
                case 1: {
                    int j2;
                    for (j2 = 0; j2 < this.tfRoute.length; ++j2) {
                        if (rid[j2] <= 0) continue;
                        this.myRealm.removeRidBoth(here, dir, rid[j2]);
                    }
                    continue block6;
                }
            }
        }
        for (j = 0; j < this.tfRoute.length; ++j) {
            if (rid[j] <= 0) continue;
            this.myRealm.findRouteStart(rid[j]);
            this.myRealm.findRouteEnd(rid[j]);
        }
        this.myPanel.askRefresh(7);
        this.clearErrorMessage();
    }

    public void reportRoadInfo(String[] route, String street, int paveType) {
        this.tfRoute[0].setText(new String(route[0]));
        this.tfRoute[1].setText(new String(route[1]));
        this.tfStreet.setText(new String(street));
        if (paveType > 0) {
            this.chPaveType.select(paveType - 1);
        }
    }
}

