/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;

public class MapUtils {
    private static Font medRouteNumberFont = new Font("Helvetica", 0, 12);
    private static Font smallRouteNumberFont = new Font("Helvetica", 0, 10);
    private static Color bgMarkerColor = Color.white;
    private static Color fgMarkerColor = Color.black;
    public static Color dirtRoadColor = new Color(153, 153, 102);
    public static Color streetColor = Color.gray;
    public static Color highwayColor = Color.red.darker();
    public static Color townLineColor = Color.lightGray;
    public static Color townNameColor = Color.blue;
    public static Color selectionColor = Color.green;
    public static Color oceanColor = Color.cyan.brighter();
    public static final int medRoute = 1;
    public static final int smallRoute = 2;
    public static final int background = 1;
    public static final int foreground = 2;
    private static int[] dx2l = new int[]{-1, -1, 0, 0, -1, 0, 0, 1};
    private static int[] dy2l = new int[]{0, 0, -1, -1, 0, -1, -1, 0};
    private static int[] dx2r = new int[]{1, 1, 0, -1, 1, 1, 0, -1};
    private static int[] dy2r = new int[]{0, 1, 1, 1, 0, 1, 1, 1};
    private static int[] gdx = new int[]{0, 4, 5, 4, 0, -4, -5, -4};
    private static int[] gdy = new int[]{-5, -4, 0, 4, 5, 4, 0, -4};
    private static int[] gxl = new int[]{-2, -2, 0, 2, 2, 2, 0, -2};
    private static int[] gyl = new int[]{0, -2, -2, -2, 0, 2, 2, 2};
    static int boxHalfLength = 3;
    static int boxHalfDiag = 4;

    public static void setFont(int which, Font f) {
        switch (which) {
            case 1: {
                medRouteNumberFont = f;
                break;
            }
            case 2: {
                smallRouteNumberFont = f;
            }
        }
    }

    public static Font getFont(int which) {
        switch (which) {
            case 1: {
                return medRouteNumberFont;
            }
            case 2: {
                return smallRouteNumberFont;
            }
        }
        return null;
    }

    public static void setMarkerColor(int which, Color c) {
        switch (which) {
            case 1: {
                bgMarkerColor = c;
                break;
            }
            case 2: {
                fgMarkerColor = c;
            }
        }
    }

    public static void drawMarker(Graphics g, int xc, int yc, int number) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHints(hints);
        g2.setFont(medRouteNumberFont);
        FontMetrics fm = g2.getFontMetrics();
        String s = String.valueOf(number);
        int rw = fm.stringWidth(s);
        int rh = fm.getHeight();
        int paddingX = rh / 4;
        int paddingY = rh / 4;
        int dyr = -1;
        int dxm = -1;
        int mx = xc - rw / 2 - paddingX + dxm;
        int my = yc - rh / 2 - paddingY;
        int mw = rw + 2 * paddingX;
        int mh = rh + 2 * paddingY;
        g2.setColor(bgMarkerColor);
        g2.fillOval(mx, my, mw, mh);
        g2.setColor(fgMarkerColor);
        g2.drawOval(mx, my, mw, mh);
        g2.drawString(s, xc - rw / 2, yc + rh / 2 + dyr);
    }

    public static void drawMarker(Graphics g, int xc, int yc, int num0, int num1) {
        g.setFont(smallRouteNumberFont);
        FontMetrics fm = g.getFontMetrics();
        String s0 = String.valueOf(num0);
        String s1 = String.valueOf(num1);
        int sw0 = fm.stringWidth(s0);
        int sw1 = fm.stringWidth(s1);
        int sw = Math.max(sw0, sw1);
        int dh = fm.getHeight();
        g.setColor(bgMarkerColor);
        g.fillOval(xc - sw / 2 - 5, yc - dh - 2, sw + 8, dh * 2 + 5);
        g.setColor(fgMarkerColor);
        g.drawOval(xc - sw / 2 - 5, yc - dh - 2, sw + 8, dh * 2 + 5);
        g.drawString(s0, xc - sw0 / 2 - 1, yc - 1);
        g.drawString(s1, xc - sw1 / 2 - 1, yc + dh - 2);
    }

    public static void drawDoubleLine(Graphics g, int dir, int x0, int y0, int x1, int y1) {
        int x2 = x0 + dx2l[dir];
        int y2 = y0 + dy2l[dir];
        int x3 = x1 + dx2l[(dir + 4) % 8];
        int y3 = y1 + dy2l[(dir + 4) % 8];
        g.drawLine(x2, y2, x3, y3);
        x2 = x0 + dx2r[dir];
        y2 = y0 + dy2r[dir];
        x3 = x1 + dx2r[(dir + 4) % 8];
        y3 = y1 + dy2r[(dir + 4) % 8];
        g.drawLine(x2, y2, x3, y3);
    }

    public static void drawRoadSegment(Graphics g, Color lineColor, boolean isDivided, int dir, int xc, int yc, int x1, int y1) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHints(hints);
        if (isDivided) {
            g2.setColor(Color.white);
            g2.drawLine(xc, yc, x1, y1);
            g2.setColor(lineColor);
            MapUtils.drawDoubleLine(g2, dir, xc, yc, x1, y1);
        } else {
            g2.setColor(lineColor);
            g2.drawLine(xc, yc, x1, y1);
        }
    }

    public static void drawGradeSeps(Graphics g, int dir, int xc, int yc, boolean divided) {
        int xl = xc;
        int xr = xc;
        int yl = yc;
        int yr = yc;
        if (divided) {
            xl += dx2l[dir];
            yl += dy2l[dir];
            xr += dx2r[dir];
            yr += dy2r[dir];
        }
        int rev = (dir + 4) % 8;
        int xlb = xl + gdx[dir] + gxl[dir];
        int ylb = yl + gdy[dir] + gyl[dir];
        int xlf = xl + gdx[rev] - gxl[rev];
        int ylf = yl + gdy[rev] - gyl[rev];
        int xrf = xr + gdx[rev] - gxl[dir];
        int yrf = yr + gdy[rev] - gyl[dir];
        int xrb = xr + gdx[dir] + gxl[rev];
        int yrb = yr + gdy[dir] + gyl[rev];
        Polygon po = new Polygon();
        po.addPoint(xlb, ylb);
        po.addPoint(xlf, ylf);
        po.addPoint(xrf, yrf);
        po.addPoint(xrb, yrb);
        g.setColor(Color.white);
        g.fillPolygon(po);
        g.setColor(Color.gray);
        g.drawLine(xlb, ylb, xlf, ylf);
        g.drawLine(xrb, yrb, xrf, yrf);
    }

    public static void drawInterchangeBox(Graphics g, int xc, int yc, boolean diagonal) {
        if (diagonal) {
            Polygon po = new Polygon();
            po.addPoint(xc, yc - boxHalfDiag);
            po.addPoint(xc + boxHalfDiag, yc);
            po.addPoint(xc, yc + boxHalfDiag);
            po.addPoint(xc - boxHalfDiag, yc);
            g.setColor(Color.white);
            g.fillPolygon(po);
            g.setColor(Color.black);
            g.drawPolygon(po);
        } else {
            g.setColor(Color.white);
            g.fillRect(xc - boxHalfLength, yc - boxHalfLength, 2 * boxHalfLength, 2 * boxHalfLength);
            g.setColor(Color.black);
            g.drawRect(xc - boxHalfLength, yc - boxHalfLength, 2 * boxHalfLength, 2 * boxHalfLength);
        }
    }
}

