/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.Realm;
import java.awt.Point;
import java.util.Random;

public class Junction {
    public static final int north = 0;
    public static final int northeast = 1;
    public static final int east = 2;
    public static final int southeast = 3;
    public static final int south = 4;
    public static final int southwest = 5;
    public static final int west = 6;
    public static final int northwest = 7;
    public static final int numDirs = 8;
    public static String[] dirStrings = new String[]{"north", "northeast", "east", "southeast", "south", "southwest", "west", "northwest"};
    public static String[] dirStrings90 = new String[]{"north", "east", "south", "west"};
    public static String[] dirAbbs = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};
    public static final int ahead = 0;
    public static final int veerright = 1;
    public static final int right = 2;
    public static final int back = 4;
    public static final int left = 6;
    public static final int veerleft = 7;
    public static final int empty = 0;
    public static final int deadend = 1;
    public static final int straight = 2;
    public static final int curve = 4;
    public static final int twoway = 6;
    public static final int threeway = 8;
    public static final int fourway = 16;
    public static final int unknown = 256;
    public static final int none = 0;
    public static final int dirt = 1;
    public static final int undiv2 = 2;
    public static final int undiv4 = 3;
    public static final int div4 = 4;
    public static final int div6 = 5;
    public static String[] paveStrings = new String[]{"no road", "dirt road", "2 lane", "4 lane", "4 lane div"};
    public static final int brNorth = 1;
    public static final int brNortheast = 2;
    public static final int brEast = 3;
    public static final int brSoutheast = 4;
    public static int maxOverlappingRoutes = 2;
    private static Random dice = new Random();
    private static final short forwardMask = 1024;
    private static final int ridMask = 1023;
    public static final int maxRouteIndex = 1023;
    private static final int[] layoutMask = new int[]{1, 8, 64, 512, 4096, 32768, 262144, 0x200000};
    short[][] rd = new short[8][maxOverlappingRoutes];
    short[] sd = new short[8];
    short bridge = 0;
    int layout;

    public static int getGlobalDirection(int heading, int facing) {
        return (heading + facing + 8) % 8;
    }

    public static int getReverseDirection(int heading) {
        return Junction.getGlobalDirection(heading, 4);
    }

    public static int getRandomDirection45() {
        int dir = dice.nextInt() & 7;
        return dir;
    }

    public static int getRandomDirection90() {
        return Junction.getRandomDirection45() & 0xFFFFFFFE;
    }

    public static void move(Point p, int heading) {
        switch (heading) {
            case 0: {
                --p.y;
                break;
            }
            case 1: {
                ++p.x;
                --p.y;
                break;
            }
            case 2: {
                ++p.x;
                break;
            }
            case 3: {
                ++p.x;
                ++p.y;
                break;
            }
            case 4: {
                ++p.y;
                break;
            }
            case 5: {
                --p.x;
                ++p.y;
                break;
            }
            case 6: {
                --p.x;
                break;
            }
            case 7: {
                --p.x;
                --p.y;
            }
        }
    }

    public static void move(Point p, int heading, int facing) {
        Junction.move(p, Junction.getGlobalDirection(heading, facing));
    }

    public static int getDirection(Point here, Point next) {
        int dx = next.x - here.x;
        int dy = next.y - here.y;
        switch (dy) {
            case -1: {
                switch (dx) {
                    case -1: {
                        return 7;
                    }
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                }
                break;
            }
            case 1: {
                switch (dx) {
                    case -1: {
                        return 5;
                    }
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 3;
                    }
                }
                break;
            }
            default: {
                switch (dx) {
                    case -1: {
                        return 6;
                    }
                    case 1: {
                        return 2;
                    }
                }
            }
        }
        return -1;
    }

    public static boolean isDiagonal(int dir) {
        return dir % 2 != 0;
    }

    public static int dirFromString(String str) {
        for (int k = 0; k < 8; ++k) {
            if (!str.equalsIgnoreCase(dirStrings[k]) && !str.equalsIgnoreCase(dirAbbs[k])) continue;
            return k;
        }
        return -1;
    }

    public static int dirFromString90(String str) {
        for (int k = 0; k < 8; k += 2) {
            if (!str.equalsIgnoreCase(dirStrings[k]) && !str.equalsIgnoreCase(dirAbbs[k])) continue;
            return k;
        }
        return -1;
    }

    public static int dirFromChoice4(int selectedItem) {
        if (selectedItem >= 0 && selectedItem <= 3) {
            return selectedItem * 2;
        }
        return -1;
    }

    Junction() {
        this(0);
    }

    Junction(int layout_) {
        this.layout = layout_;
    }

    public void clear() {
        for (int i = 0; i < 8; ++i) {
            this.rd[i][1] = 0;
            this.rd[i][0] = 0;
            this.sd[i] = 0;
        }
        this.layout = 0;
    }

    public void clearLeg(int dir) {
        this.setPavement(dir, 0);
        this.rd[dir][0] = 0;
        this.rd[dir][1] = 0;
        this.sd[dir] = 0;
    }

    public int anyRidExcept(int rid) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (this.rd[i][j] <= 0 || (this.rd[i][j] & 0x3FF) == rid) continue;
                return this.rd[i][j] & 0x3FF;
            }
        }
        return 0;
    }

    public final int ridAt(int direction, int which) {
        return this.rd[direction][which] & 0x3FF;
    }

    public int[] ridsAt(int direction) {
        int[] rids = new int[]{this.rd[direction][0] & 0x3FF, this.rd[direction][1] & 0x3FF};
        return rids;
    }

    public boolean hasNoRoutes(int direction) {
        return this.rd[direction][0] == 0;
    }

    public final boolean isRidFwdAt(int direction, int which) {
        return (this.rd[direction][which] & 0x400) > 0;
    }

    public int getForwardDirection(int rid) {
        return this.getBackwardDirection(rid | 0x400);
    }

    public int getBackwardDirection(int rid) {
        for (int dir = 0; dir < this.rd.length; ++dir) {
            if (this.rd[dir][0] != rid && this.rd[dir][1] != rid) continue;
            return dir;
        }
        return -1;
    }

    public int getForwardDirectionStrict(int rid) {
        return this.getBackwardDirectionStrict(rid | 0x400);
    }

    public int getBackwardDirectionStrict(int rid) {
        int answer = -1;
        int numLegs = 0;
        for (int dir = 0; dir < this.rd.length; ++dir) {
            if (this.rd[dir][0] != rid && this.rd[dir][1] != rid) continue;
            answer = dir;
            ++numLegs;
        }
        if (numLegs < 2) {
            return answer;
        }
        return -1;
    }

    public int ridToLeftDir(int aheadDir) {
        for (int i = -1; i >= -3; --i) {
            int tryDir = Junction.getGlobalDirection(aheadDir, i);
            if (this.ridAt(tryDir, 0) <= 0) continue;
            return tryDir;
        }
        return -1;
    }

    public int ridToRightDir(int aheadDir) {
        for (int i = 1; i <= 3; ++i) {
            int tryDir = Junction.getGlobalDirection(aheadDir, i);
            if (this.ridAt(tryDir, 0) <= 0) continue;
            return tryDir;
        }
        return -1;
    }

    public boolean isRouteStart(int rid) {
        int answer = -1;
        for (int dir = 0; dir < this.rd.length; ++dir) {
            if (this.rd[dir][0] == (rid | 0x400) || this.rd[dir][1] == (rid | 0x400)) {
                answer = dir;
            }
            if (this.rd[dir][0] != rid && this.rd[dir][1] != rid) continue;
            return false;
        }
        return answer >= 0;
    }

    public boolean isRouteEnd(int rid) {
        int answer = -1;
        for (int dir = 0; dir < this.rd.length; ++dir) {
            if (this.rd[dir][0] == rid || this.rd[dir][1] == rid) {
                answer = dir;
            }
            if (this.rd[dir][0] != (rid | 0x400) && this.rd[dir][1] != (rid | 0x400)) continue;
            return false;
        }
        return answer >= 0;
    }

    public boolean ridLeavesDiagonally(int rid) {
        return (this.getForwardDirection(rid) & 1) > 0;
    }

    public boolean containsRoute(int rid) {
        rid &= 0x3FF;
        for (int dir = 0; dir < this.rd.length; ++dir) {
            if ((this.rd[dir][0] & 0x3FF) != rid && (this.rd[dir][1] & 0x3FF) != rid) continue;
            return true;
        }
        return false;
    }

    boolean isRouteJunction() {
        int ridSeen = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j <= 1; ++j) {
                if (this.rd[i][j] == 0) continue;
                if (ridSeen == 0) {
                    ridSeen = this.rd[i][j] & 0x3FF;
                    continue;
                }
                if (ridSeen == (this.rd[i][j] & 0x3FF)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isRouteInflection() {
        int i;
        int[] ridLegs = new int[8];
        int numRidLegs = 0;
        for (i = 0; i < 8; ++i) {
            if (this.rd[i][0] <= 0 && this.rd[i][1] <= 0) continue;
            ridLegs[numRidLegs++] = i;
        }
        if (numRidLegs != 2) {
            return true;
        }
        for (i = 0; i < numRidLegs; ++i) {
            int rid00 = this.rd[ridLegs[0]][0] & 0x3FF;
            int rid01 = this.rd[ridLegs[0]][1] & 0x3FF;
            int rid10 = this.rd[ridLegs[1]][0] & 0x3FF;
            int rid11 = this.rd[ridLegs[1]][1] & 0x3FF;
            if (rid10 != 0 && rid10 != rid01 && rid10 != rid00) {
                return true;
            }
            if (rid11 == 0 || rid11 == rid01 || rid11 == rid00) continue;
            return true;
        }
        return false;
    }

    boolean isFull(int direction) {
        return (this.rd[direction][1] & 0x3FF) != 0;
    }

    public void clearRids(int direction) {
        this.rd[direction][1] = 0;
        this.rd[direction][0] = 0;
    }

    private void addRid(int dir, int rid, boolean isForward) {
        int forwardBit;
        int n = forwardBit = isForward ? 1024 : 0;
        if (this.rd[dir][0] == 0) {
            this.rd[dir][0] = (short)(rid + forwardBit);
            return;
        }
        if (this.rd[dir][1] == 0 && this.rd[dir][0] != rid) {
            this.rd[dir][1] = (short)(rid + forwardBit);
        }
    }

    void addRidForward(int dir, int rid) {
        this.addRid(dir, rid, true);
    }

    void addRidBack(int dir, int rid) {
        int backDir = Junction.getGlobalDirection(dir, 4);
        this.addRid(backDir, rid, false);
    }

    void removeRid(int dir, int rid) {
        if ((this.rd[dir][1] & 0x3FF) == rid) {
            this.rd[dir][1] = 0;
        }
        if ((this.rd[dir][0] & 0x3FF) == rid) {
            this.rd[dir][0] = this.rd[dir][1];
            this.rd[dir][1] = 0;
        }
    }

    public final int sidAt(int direction) {
        return this.sd[direction] & 0x3FF;
    }

    void setStreetId(int direction, int sid, boolean forceIt) {
        if (this.sd[direction] == 0 || forceIt) {
            this.sd[direction] = (short)sid;
        }
    }

    void setStreetId(int direction, int sid) {
        this.setStreetId(direction, sid, true);
    }

    private void addStreet(int dir, int sid, int paveType, boolean isForward) {
        int existingRoad = this.pavementAt(dir);
        int forwardBit = isForward ? 1024 : 0;
        this.sd[dir] = (short)(sid + forwardBit);
        if (existingRoad < paveType) {
            this.setPavement(dir, paveType);
        }
    }

    private void removeStreet(int dir) {
        this.sd[dir] = 0;
        this.setPavement(dir, 0);
    }

    void addStreetForward(int dir, int sid, int paveType) {
        this.addStreet(dir, sid, paveType, true);
    }

    void addStreetBack(int dir, int sid, int paveType) {
        int backDir = Junction.getGlobalDirection(dir, 4);
        this.addStreet(backDir, sid, paveType, false);
    }

    void removeStreetForward(int dir) {
        this.removeStreet(dir);
    }

    void removeStreetBack(int dir) {
        int backDir = Junction.getGlobalDirection(dir, 4);
        this.removeStreet(backDir);
    }

    public int roadToLeftDir(int aheadDir) {
        for (int i = -1; i >= -3; --i) {
            int tryDir = Junction.getGlobalDirection(aheadDir, i);
            if (this.pavementAt(tryDir) <= 0) continue;
            return tryDir;
        }
        return -1;
    }

    public int roadToRightDir(int aheadDir) {
        for (int i = 1; i <= 3; ++i) {
            int tryDir = Junction.getGlobalDirection(aheadDir, i);
            if (this.pavementAt(tryDir) <= 0) continue;
            return tryDir;
        }
        return -1;
    }

    public int pavementAt(int direction) {
        int mask = layoutMask[direction];
        return (this.layout & mask * 7) / mask;
    }

    public int pavementAt(int heading, int facing) {
        return this.pavementAt(Junction.getGlobalDirection(heading, facing));
    }

    public boolean isEmpty(int direction) {
        int mask = layoutMask[direction];
        return (this.layout & mask * 7) == 0;
    }

    public boolean isEmpty(int heading, int facing) {
        return this.isEmpty(Junction.getGlobalDirection(heading, facing));
    }

    boolean isDeadEnd() {
        int nonEmpties = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.isEmpty(i) || ++nonEmpties <= 1) continue;
            return false;
        }
        return true;
    }

    boolean hasThruRoad() {
        int nonEmpties = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.isEmpty(i) || ++nonEmpties < 2) continue;
            return true;
        }
        return false;
    }

    int intersectionType() {
        int nonEmpties = 0;
        int numTwoWays = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.isEmpty(i) && !this.isEmpty(i + 4)) {
                ++numTwoWays;
            }
            if (!this.isEmpty(i)) {
                ++nonEmpties;
            }
            if (this.isEmpty(i + 4)) continue;
            ++nonEmpties;
        }
        switch (nonEmpties) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                if (numTwoWays > 0) {
                    return 2;
                }
                return 4;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
        }
        return 256;
    }

    boolean isTwoWay() {
        return (this.intersectionType() & 6) > 0;
    }

    boolean isTwoWayDivided() {
        if (!this.isTwoWay()) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (this.isEmpty(i) || this.isDivided(i)) continue;
            return false;
        }
        return true;
    }

    boolean isThreeWayOrMore() {
        return this.intersectionType() >= 8;
    }

    boolean isSuitableForLeg(int dir) {
        int numTwoWays = 0;
        int numLegs = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.isEmpty(i) || !this.isEmpty(i + 4) || dir == i || dir == i + 4) {
                ++numTwoWays;
            }
            if (!this.isEmpty(i) || dir == i) {
                ++numLegs;
            }
            if (this.isEmpty(i + 4) && dir != i + 4) continue;
            ++numLegs;
        }
        if (numTwoWays > 2 & numLegs == 3) {
            int[] legAt = new int[3];
            int[] diffs = new int[3];
            int which = 0;
            for (int i = 0; i < 8; ++i) {
                if (this.isEmpty(i) && dir != i) continue;
                legAt[which++] = i;
            }
            diffs[0] = legAt[1] - legAt[0];
            diffs[1] = legAt[2] - legAt[1];
            diffs[2] = legAt[0] - legAt[2] + 8;
            return diffs[0] + diffs[1] >= 4 && diffs[1] + diffs[2] >= 4 && diffs[2] + diffs[0] >= 4;
        }
        return numTwoWays <= 2 || numLegs <= 3;
    }

    void setPavement(int direction, int paveType) {
        int mask = layoutMask[direction];
        this.layout = this.layout & ~(7 * mask) | mask * paveType;
    }

    void setWiderPavement(int dir, int paveType) {
        if (this.pavementAt(dir) < paveType) {
            this.setPavement(dir, paveType);
        }
    }

    boolean isDivided(int dir) {
        switch (this.pavementAt(dir)) {
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    static boolean isPaveTypeDivided(int what) {
        switch (what) {
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    int countLanes(int dir) {
        switch (this.pavementAt(dir)) {
            case 5: {
                return 6;
            }
            case 3: 
            case 4: {
                return 4;
            }
            case 1: 
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    boolean accessOK(int heading, int facing) {
        switch (facing) {
            case 0: 
            case 2: 
            case 6: {
                return this.pavementAt(heading, facing) > 0;
            }
            case 4: {
                if (this.intersectionType() == 4) {
                    return false;
                }
                return this.pavementAt(heading, facing) > 0;
            }
        }
        return false;
    }

    String describe(Realm theRealm, int excludeRoute) {
        String desc = "";
        if (this.intersectionType() == 1) {
            return "Dead end";
        }
        int fwd = this.getForwardDirection(excludeRoute);
        int rev = this.getBackwardDirection(excludeRoute);
        int fwdOverlap = 0;
        if (!(fwd < 0 || (fwdOverlap = this.rd[fwd][0] & 0x3FF) > 0 && fwdOverlap != excludeRoute || (fwdOverlap = this.rd[fwd][1] & 0x3FF) > 0 && fwdOverlap != excludeRoute)) {
            fwdOverlap = 0;
        }
        int revOverlap = 0;
        if (!(rev < 0 || (revOverlap = this.rd[rev][0] & 0x3FF) > 0 && revOverlap != excludeRoute || (revOverlap = this.rd[rev][1] & 0x3FF) > 0 && revOverlap != excludeRoute)) {
            revOverlap = 0;
        }
        if (fwdOverlap > 0 && fwdOverlap != revOverlap) {
            desc = desc + "Begin overlap rte " + theRealm.routes[fwdOverlap].getNumber() + " ";
        }
        if (revOverlap > 0 && fwdOverlap != revOverlap) {
            desc = desc + "End overlap rte " + theRealm.routes[revOverlap].getNumber() + " ";
        }
        int[] routesSeen = new int[16];
        int numRoutesSeen = 0;
        for (int i = 0; i < this.rd.length; ++i) {
            if (i == fwd || i == rev) continue;
            for (int which = 0; which <= 1; ++which) {
                int rid = this.rd[i][which] & 0x3FF;
                if (rid <= 0 || rid == fwdOverlap || rid == revOverlap) continue;
                boolean found = false;
                for (int j = 0; j < numRoutesSeen; ++j) {
                    if (rid != routesSeen[j]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                routesSeen[numRoutesSeen++] = rid;
            }
        }
        if (numRoutesSeen > 0) {
            desc = desc + "Jct";
            for (int j = 0; j < numRoutesSeen; ++j) {
                desc = desc + " rte " + theRealm.routes[routesSeen[j]].getNumber();
            }
        }
        if (desc.length() == 0) {
            int[] seenSid = new int[8];
            int nSeen = 0;
            boolean seenIt = false;
            for (int i = 0; i < 8; ++i) {
                int sid;
                if (i == fwd || i == rev || (sid = this.sidAt(i)) <= 0) continue;
                seenIt = false;
                for (int j = 0; j < nSeen; ++j) {
                    if (sid != seenSid[j]) continue;
                    seenIt = true;
                    break;
                }
                if (seenIt) continue;
                desc = desc + theRealm.streetNames[sid] + " ";
                seenSid[nSeen++] = sid;
            }
        }
        return desc;
    }

    void dump() {
        System.out.println("junc dump:");
        for (int i = 0; i < 8; ++i) {
            int rid0 = this.rd[i][0] & 0x3FF;
            int rid1 = this.rd[i][1] & 0x3FF;
            int sid = this.sd[i] & 0x3FF;
            char fwd0 = (this.rd[i][0] & 0x400) > 0 ? (char)'>' : '<';
            char fwd1 = (this.rd[i][1] & 0x400) > 0 ? (char)'>' : '<';
            char fwds = (this.sd[i] & 0x400) > 0 ? (char)'>' : '<';
            System.out.print(dirAbbs[i] + ": ");
            if (this.pavementAt(i) > 0) {
                System.out.print("p" + this.pavementAt(i) + " ");
                System.out.print("rd's: " + rid0 + fwd0);
                System.out.print(", " + rid1 + fwd1 + "; ");
                System.out.println("sd: " + sid + fwds);
                continue;
            }
            System.out.println("");
        }
    }
}

