/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.IntersectionViewerClient;
import com.kurumi.matr.Junction;
import com.kurumi.matr.Realm;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class IntersectionViewerFrame
extends JFrame {
    private JButton bClose = new JButton("Close");
    private JButton bTurnLeft = new JButton("\u293e");
    private JButton bTurnRight = new JButton("\u293f");
    private IntersectionViewerClient viewerClient;
    private JComboBox<String> chDir = new JComboBox<String>(Junction.dirStrings);
    private Realm myRealm;
    private Point player = new Point();
    private int dirFacing = 0;

    IntersectionViewerFrame(Realm r) {
        super("Intersection View");
        this.myRealm = r;
        this.viewerClient = new IntersectionViewerClient(r);
        this.setLayout(new BorderLayout());
        Panel p = new Panel();
        p.setLayout(new FlowLayout(2));
        p.add(new Label("  facing:"));
        p.add(this.chDir);
        p.add(this.bTurnLeft);
        p.add(this.bTurnRight);
        p.add(this.bClose);
        this.bTurnLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntersectionViewerFrame.this.dirFacing++;
                if (IntersectionViewerFrame.this.dirFacing > 7) {
                    IntersectionViewerFrame.this.dirFacing = 0;
                }
                IntersectionViewerFrame.this.chDir.setSelectedIndex(IntersectionViewerFrame.this.dirFacing);
                IntersectionViewerFrame.this.movePlayer();
            }
        });
        this.bTurnRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntersectionViewerFrame.this.dirFacing--;
                if (IntersectionViewerFrame.this.dirFacing < 0) {
                    IntersectionViewerFrame.this.dirFacing = 7;
                }
                IntersectionViewerFrame.this.chDir.setSelectedIndex(IntersectionViewerFrame.this.dirFacing);
                IntersectionViewerFrame.this.movePlayer();
            }
        });
        this.chDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntersectionViewerFrame.this.dirFacing = IntersectionViewerFrame.this.chDir.getSelectedIndex();
                IntersectionViewerFrame.this.movePlayer();
            }
        });
        this.bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntersectionViewerFrame.this.setVisible(false);
            }
        });
        this.add("South", p);
        this.add("Center", this.viewerClient);
        this.setBounds(250, 250, 540, 300);
        Point here = this.myRealm.towns[1].getCenter();
        this.player.setLocation(here);
        this.chDir.setSelectedIndex(0);
        this.movePlayer();
    }

    public void setViewerLocation(int x, int y) {
        this.player.setLocation(x, y);
        this.movePlayer();
    }

    public void refresh() {
        this.viewerClient.repaint();
    }

    private void movePlayer() {
        this.viewerClient.movePlayer(this.player, this.dirFacing);
    }
}

