/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.Junction;
import com.kurumi.matr.MyTools;
import com.kurumi.matr.Realm;
import com.kurumi.matr.Signpost;
import com.kurumi.matr.Streetpost;
import com.kurumi.matr.VEdge;
import com.kurumi.matr.VPoly;
import com.kurumi.matr.XyzPoint;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Vector;

class IntersectionViewerClient
extends Canvas {
    public static Color skyColor = new Color(0, 191, 255);
    public static Color groundColor = new Color(34, 140, 34);
    private static int fustrum = 300;
    private static int camHeightFt = 5;
    private static int stripeWidth = 4;
    private static int dashLengthFeet = 4;
    private static int interLengthFeet = 6;
    private static int dashLengthInches = dashLengthFeet * 12;
    private static int interLengthInches = interLengthFeet * 12;
    private static int singleLaneWidthFeet = 10;
    private static int medianWidth = 16;
    private int width;
    private int height;
    private int xCam = 5;
    private int zCam = 0;
    Realm myRealm;
    Signpost left = new Signpost(0, 0);
    Signpost ahead = new Signpost(0, 0);
    Signpost right = new Signpost(0, 0);
    Streetpost street = new Streetpost(0, 0);
    public static int fullSquareFeet = 1056;
    public static int halfSquareFeet = fullSquareFeet / 2;
    Point sqPlayer = new Point(0, 0);
    int aheadDir = 0;
    int[] sines = new int[]{0, 392, 724, 946, 1024, 946, 724, 392, 0};
    int[] cosines = new int[]{1024, 946, 724, 392, 0, -392, -724, -946, -1024};
    static final int clipZFeet = 10;
    static final int clipZInches = 120;
    int[] setBacks = new int[8];

    IntersectionViewerClient(Realm r) {
        this.myRealm = r;
    }

    private void cacheSize() {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
    }

    private Point project(int x, int y, int z) {
        y = -y + camHeightFt;
        if (z <= 0) {
            z = 1;
        }
        return new Point(x * fustrum / z + this.width / 2, y * fustrum / z + this.height / 2);
    }

    private Point projectInch(int x, int y, int z) {
        y = -y + camHeightFt * 12;
        if (z <= 0) {
            z = 1;
        }
        int sx = x * fustrum / z + this.width / 2;
        int sy = y * fustrum / z + this.height / 2;
        return new Point(sx, sy);
    }

    private void rotate(XyzPoint[] p, int thetaPi8) {
        int cos;
        int sin;
        if ((thetaPi8 %= 16) > 8) {
            sin = -this.sines[16 - thetaPi8];
            cos = this.cosines[16 - thetaPi8];
        } else {
            sin = this.sines[thetaPi8];
            cos = this.cosines[thetaPi8];
        }
        for (int i = 0; i < p.length; ++i) {
            int ax = p[i].x;
            int az = p[i].z;
            p[i].z = (az * cos - ax * sin) / 1024;
            p[i].x = (ax * cos + az * sin) / 1024;
        }
    }

    private void rotate(VEdge v, int thetaPi8) {
        XyzPoint[] alias = new XyzPoint[]{v.near, v.far};
        this.rotate(alias, thetaPi8);
    }

    private Polygon projectPoly(Vector<XyzPoint> v) {
        Polygon po = new Polygon();
        for (int i = 0; i < v.size(); ++i) {
            XyzPoint xyz = v.elementAt(i);
            Point p = this.project(xyz.x, xyz.y, xyz.z);
            po.addPoint(p.x, p.y);
        }
        return po;
    }

    private static XyzPoint[] clip(XyzPoint[] orig, int clipz) {
        XyzPoint[] working = new XyzPoint[orig.length + 1];
        int ri = 0;
        for (int i = 0; i < orig.length; ++i) {
            int zdiff;
            XyzPoint next;
            XyzPoint here = orig[i];
            XyzPoint xyzPoint = next = i < orig.length - 1 ? orig[i + 1] : orig[0];
            if (here.z >= clipz) {
                working[ri++] = new XyzPoint(here);
            }
            if (next.z >= clipz && here.z < clipz) {
                zdiff = next.z - here.z;
                working[ri] = new XyzPoint(0, 0, clipz);
                working[ri].x = here.x + (clipz - here.z) * (next.x - here.x) / zdiff;
                working[ri].y = here.y + (clipz - here.z) * (next.y - here.y) / zdiff;
                ++ri;
            }
            if (next.z >= clipz || here.z < clipz) continue;
            zdiff = here.z - next.z;
            working[ri] = new XyzPoint(0, 0, clipz);
            working[ri].x = next.x + (clipz - next.z) * (here.x - next.x) / zdiff;
            working[ri].y = next.y + (clipz - next.z) * (here.y - next.y) / zdiff;
            ++ri;
        }
        XyzPoint[] result = new XyzPoint[ri];
        for (int i = 0; i < ri; ++i) {
            result[i] = new XyzPoint(working[i]);
        }
        return result;
    }

    private static Vector<XyzPoint> clip(Vector<XyzPoint> orig, int clipz) {
        Vector<XyzPoint> working = new Vector<XyzPoint>();
        for (int i = 0; i < orig.size(); ++i) {
            int zdiff;
            XyzPoint newone;
            XyzPoint here = orig.elementAt(i);
            XyzPoint next = i == orig.size() - 1 ? orig.elementAt(0) : orig.elementAt(i + 1);
            if (here.z >= clipz) {
                newone = new XyzPoint(here);
                working.addElement(newone);
            }
            if (next.z >= clipz && here.z < clipz) {
                zdiff = next.z - here.z;
                newone = new XyzPoint(0, 0, clipz);
                newone.x = here.x + (clipz - here.z) * (next.x - here.x) / zdiff;
                newone.y = here.y + (clipz - here.z) * (next.y - here.y) / zdiff;
                working.addElement(newone);
            }
            if (next.z >= clipz || here.z < clipz) continue;
            zdiff = here.z - next.z;
            newone = new XyzPoint(0, 0, clipz);
            newone.x = next.x + (clipz - next.z) * (here.x - next.x) / zdiff;
            newone.y = next.y + (clipz - next.z) * (here.y - next.y) / zdiff;
            working.addElement(newone);
        }
        return working;
    }

    private Polygon projectPoly(XyzPoint[] foo, int length) {
        Polygon po = new Polygon();
        for (int i = 0; i < length; ++i) {
            Point p = this.project(foo[i].x, foo[i].y, foo[i].z);
            po.addPoint(p.x, p.y);
        }
        return po;
    }

    private Polygon projectPolyInch(XyzPoint[] foo) {
        Polygon po = new Polygon();
        for (int i = 0; i < foo.length; ++i) {
            Point p = this.projectInch(foo[i].x, foo[i].y, foo[i].z);
            po.addPoint(p.x, p.y);
        }
        return po;
    }

    void translate(XyzPoint[] foo, int x, int y, int z) {
        for (int i = 0; i < foo.length; ++i) {
            foo[i].x += x;
            foo[i].y += y;
            foo[i].z += z;
        }
    }

    void translate(Vector<XyzPoint> v, int x, int y, int z) {
        for (int i = 0; i < v.size(); ++i) {
            XyzPoint p = v.elementAt(i);
            p.x += x;
            p.y += y;
            p.z += z;
        }
    }

    public void drawDoubleSolidStripe(Graphics g, int x, int z, int len, int dir) {
        int wid = stripeWidth;
        int[] yp = new int[]{0, 0, 0, 0};
        int[] xp = new int[]{(x *= 12) + wid / 2, x - wid / 2, x - wid / 2, x + wid / 2};
        int[] zp = new int[]{z + (len *= 12), (z *= 12) + len, z, z};
        XyzPoint[] foo = XyzPoint.makeXyz(xp, yp, zp, xp.length);
        this.rotate(foo, dir * 2);
        this.translate(foo, -this.xCam * 12 - wid, 0, (halfSquareFeet - this.zCam) * 12);
        g.fillPolygon(this.projectPolyInch(IntersectionViewerClient.clip(foo, 120)));
        foo = XyzPoint.makeXyz(xp, yp, zp, xp.length);
        this.rotate(foo, dir * 2);
        this.translate(foo, -this.xCam * 12 + wid, 0, (halfSquareFeet - this.zCam) * 12);
        g.fillPolygon(this.projectPolyInch(IntersectionViewerClient.clip(foo, 120)));
    }

    public void drawDashedStripe(Graphics g, int x, int z, int len, int dir) {
        int wid = stripeWidth;
        len *= 12;
        int[] yp = new int[]{0, 0, 0, 0};
        int[] xp = new int[]{(x *= 12) + wid / 2, x - wid / 2, x - wid / 2, x + wid / 2};
        int[] zp = new int[]{(z *= 12) + dashLengthInches, z + dashLengthInches, z, z};
        int zoffset = 0;
        for (zoffset = 0; zoffset < len; zoffset += dashLengthInches + interLengthInches) {
            XyzPoint[] foo = XyzPoint.makeXyz(xp, yp, zp, xp.length);
            this.translate(foo, 0, 0, zoffset);
            this.rotate(foo, dir * 2);
            this.translate(foo, -this.xCam * 12, 0, (halfSquareFeet - this.zCam) * 12);
            g.fillPolygon(this.projectPolyInch(IntersectionViewerClient.clip(foo, 120)));
        }
    }

    private void drawLaneStripes(Graphics g, int nStripes, int curb, int startz, int endz, int facing) {
        for (int i = 0; i < nStripes; ++i) {
            int sx = curb + singleLaneWidthFeet * (2 * i + 1);
            this.drawDashedStripe(g, sx, startz, endz, facing);
            this.drawDashedStripe(g, -sx, startz, endz, facing);
        }
    }

    private void drawStripesAcross(Graphics g, Junction j) {
        int facing1 = -1;
        int facing2 = -1;
        int dir1 = -1;
        int dir2 = -1;
        for (int facing = 0; facing < 8; ++facing) {
            int dir = Junction.getGlobalDirection(this.aheadDir, facing);
            if (j.isEmpty(dir)) continue;
            facing1 = facing;
            facing2 = Junction.getReverseDirection(facing);
            dir1 = dir;
            dir2 = Junction.getReverseDirection(dir);
            break;
        }
        g.setColor(Color.yellow);
        if (!j.isDivided(dir1) && !j.isDivided(dir2)) {
            this.drawDoubleSolidStripe(g, 0, -halfSquareFeet, fullSquareFeet, facing1);
        } else if (!j.isDivided(dir1)) {
            this.drawDoubleSolidStripe(g, 0, 0, halfSquareFeet, facing1);
        } else if (!j.isDivided(dir2)) {
            this.drawDoubleSolidStripe(g, 0, 0, halfSquareFeet, facing2);
        }
        g.setColor(Color.white);
        int stripes1 = j.countLanes(dir1) / 2 - 1;
        int stripes2 = j.countLanes(dir2) / 2 - 1;
        int curb = 0;
        if (j.isDivided(dir1) == j.isDivided(dir2)) {
            curb = j.isDivided(dir1) ? medianWidth / 2 : 0;
            int minStripes = Math.min(stripes1, stripes2);
            this.drawLaneStripes(g, minStripes, curb, -halfSquareFeet, fullSquareFeet, facing1);
            if (stripes1 > stripes2) {
                this.drawLaneStripes(g, stripes1, curb, 0, halfSquareFeet, facing1);
            }
            if (stripes2 > stripes1) {
                this.drawLaneStripes(g, stripes2, curb, 0, halfSquareFeet, facing2);
            }
        } else {
            curb = j.isDivided(dir1) ? medianWidth / 2 : 0;
            this.drawLaneStripes(g, stripes1, curb, 0, halfSquareFeet, facing1);
            curb = j.isDivided(dir2) ? medianWidth / 2 : 0;
            this.drawLaneStripes(g, stripes2, curb, 0, halfSquareFeet, facing2);
        }
    }

    private void calcSetBacks(Junction j) {
        int dir;
        int[] widths = new int[8];
        for (dir = 0; dir < 8; ++dir) {
            if (j.isEmpty(dir)) continue;
            widths[dir] = singleLaneWidthFeet * j.countLanes(dir);
            if (j.isDivided(dir)) {
                int n = dir;
                widths[n] = widths[n] + medianWidth;
            }
            int n = dir;
            widths[n] = widths[n] / 2;
        }
        for (dir = 0; dir < 8; ++dir) {
            int sb = 20;
            int dirp1 = Junction.getGlobalDirection(dir, 1);
            int dirp2 = Junction.getGlobalDirection(dir, 2);
            int dirp3 = Junction.getGlobalDirection(dir, 3);
            int dirn1 = Junction.getGlobalDirection(dir, -1);
            int dirn2 = Junction.getGlobalDirection(dir, -2);
            int dirn3 = Junction.getGlobalDirection(dir, -3);
            if (widths[dirp3] > 0) {
                sb = Math.max(sb, widths[dirp3] * 1414 / 1000 - widths[dir]);
            }
            if (widths[dirn3] > 0) {
                sb = Math.max(sb, widths[dirn3] * 1414 / 1000 - widths[dir]);
            }
            if (widths[dirp2] > 0) {
                sb = Math.max(sb, widths[dirp2] + widths[dir]);
            }
            if (widths[dirn2] > 0) {
                sb = Math.max(sb, widths[dirn2] + widths[dir]);
            }
            if (widths[dirp1] > 0) {
                sb = Math.max(sb, widths[dirp1] * 1414 / 1000 + widths[dir]);
            }
            if (widths[dirn1] > 0) {
                sb = Math.max(sb, widths[dirn1] * 1414 / 1000 + widths[dir]);
            }
            this.setBacks[dir] = sb;
        }
    }

    private void drawIntersectionStripes(Graphics g, Junction j) {
        for (int facing = 0; facing < 8; ++facing) {
            int dir = Junction.getGlobalDirection(this.aheadDir, facing);
            if (j.isEmpty(dir)) continue;
            int sb = this.setBacks[dir];
            int stripesEachSide = j.countLanes(dir) / 2 - 1;
            int curb = 0;
            if (!j.isDivided(dir) && j.pavementAt(dir) != 1) {
                g.setColor(Color.yellow);
                this.drawDoubleSolidStripe(g, 0, sb, halfSquareFeet - sb, facing);
            }
            if (j.isDivided(dir)) {
                curb = medianWidth / 2;
            }
            g.setColor(Color.white);
            this.drawLaneStripes(g, stripesEachSide, curb, sb, halfSquareFeet - sb, facing);
        }
    }

    private static VEdge makeHsVEdge(int startX) {
        return new VEdge(new XyzPoint(startX, 0, 0), new XyzPoint(startX, 0, halfSquareFeet));
    }

    private void drawTwoWayDivided(Graphics g, Junction j) {
        int facing1 = -1;
        int facing2 = -1;
        int dir1 = -1;
        int dir2 = -1;
        for (int facing = 0; facing < 8; ++facing) {
            int dir = Junction.getGlobalDirection(this.aheadDir, facing);
            if (j.isEmpty(dir)) continue;
            if (facing1 < 0) {
                facing1 = facing;
                dir1 = dir;
                continue;
            }
            facing2 = facing;
            dir2 = dir;
        }
        int pw1 = singleLaneWidthFeet * j.countLanes(dir1) / 2;
        int pw2 = singleLaneWidthFeet * j.countLanes(dir2) / 2;
        int lx = -pw1 - medianWidth / 2;
        int mlx = -medianWidth / 2;
        int mrx = medianWidth / 2;
        int rx = pw2 + medianWidth / 2;
        VEdge inbound = IntersectionViewerClient.makeHsVEdge(lx);
        VEdge inMedian = IntersectionViewerClient.makeHsVEdge(mlx);
        VEdge outMedian = IntersectionViewerClient.makeHsVEdge(mrx);
        VEdge outbound = IntersectionViewerClient.makeHsVEdge(rx);
        this.rotate(inbound, facing1 * 2);
        this.rotate(inMedian, facing1 * 2);
        this.rotate(outMedian, facing2 * 2);
        this.rotate(outbound, facing2 * 2);
        VPoly vp = new VPoly();
        vp.add(inbound, inMedian);
        vp.add(outMedian, outbound);
        vp.close();
        this.translate(vp.v, -this.xCam, 0, halfSquareFeet - this.zCam);
        g.fillPolygon(this.projectPoly(IntersectionViewerClient.clip(vp.v, 10)));
        lx = -pw2 - medianWidth / 2;
        rx = pw1 + medianWidth / 2;
        outMedian = IntersectionViewerClient.makeHsVEdge(mrx);
        outbound = IntersectionViewerClient.makeHsVEdge(rx);
        inbound = IntersectionViewerClient.makeHsVEdge(lx);
        inMedian = IntersectionViewerClient.makeHsVEdge(mlx);
        this.rotate(inbound, facing2 * 2);
        this.rotate(inMedian, facing2 * 2);
        this.rotate(outMedian, facing1 * 2);
        this.rotate(outbound, facing1 * 2);
        vp = new VPoly();
        vp.add(outMedian, outbound);
        vp.add(inbound, inMedian);
        vp.close();
        this.translate(vp.v, -this.xCam, 0, halfSquareFeet - this.zCam);
        g.fillPolygon(this.projectPoly(IntersectionViewerClient.clip(vp.v, 10)));
    }

    private void drawSurfaceIntersection(Graphics g, Junction j) {
        VPoly vp = new VPoly();
        for (int facing = 0; facing < 8; ++facing) {
            int lx;
            int dir = Junction.getGlobalDirection(this.aheadDir, facing);
            if (j.isEmpty(dir)) continue;
            int paveWidth = singleLaneWidthFeet * j.countLanes(dir);
            if (j.isDivided(dir)) {
                paveWidth /= 2;
            }
            if (j.isDivided(dir)) {
                lx = -paveWidth - medianWidth / 2;
                int mlx = -medianWidth / 2;
                int mrx = medianWidth / 2;
                int rx = paveWidth + medianWidth / 2;
                VEdge inbound = IntersectionViewerClient.makeHsVEdge(lx);
                VEdge inMedian = IntersectionViewerClient.makeHsVEdge(mlx);
                VEdge outMedian = IntersectionViewerClient.makeHsVEdge(mrx);
                VEdge outbound = IntersectionViewerClient.makeHsVEdge(rx);
                this.rotate(inbound, facing * 2);
                this.rotate(inMedian, facing * 2);
                this.rotate(outMedian, facing * 2);
                this.rotate(outbound, facing * 2);
                vp.add(inbound, inMedian, outMedian, outbound);
                continue;
            }
            lx = -paveWidth / 2;
            int rx = paveWidth / 2;
            VEdge inbound = IntersectionViewerClient.makeHsVEdge(lx);
            VEdge outbound = IntersectionViewerClient.makeHsVEdge(rx);
            this.rotate(inbound, facing * 2);
            this.rotate(outbound, facing * 2);
            vp.add(inbound, outbound);
        }
        if (!vp.isEmpty()) {
            vp.close();
            this.translate(vp.v, -this.xCam, 0, halfSquareFeet - this.zCam);
            g.fillPolygon(this.projectPoly(IntersectionViewerClient.clip(vp.v, 10)));
        }
    }

    @Override
    public void paint(Graphics g1) {
        int postX;
        Graphics2D g2 = MyTools.modernize(g1);
        this.cacheSize();
        int postY = this.getSize().height / 2 + 80;
        int nRoutePosts = 0;
        int[] offset = new int[]{0, 0, 24, 48};
        Junction j = this.myRealm.pToJ(this.sqPlayer);
        g2.setColor(skyColor);
        g2.fillRect(0, 0, this.width, this.height / 2);
        g2.setColor(groundColor);
        g2.fillRect(0, this.height / 2, this.width, this.height / 2);
        int dirToViewer = Junction.getReverseDirection(this.aheadDir);
        this.xCam = singleLaneWidthFeet * (j.countLanes(dirToViewer) - 1) / 2;
        if (j.isDivided(dirToViewer)) {
            this.xCam += medianWidth / 2;
        }
        if (this.xCam <= 0) {
            this.xCam = singleLaneWidthFeet / 2;
        }
        int streetX = postX = this.getSize().width / 2 + 100;
        this.calcSetBacks(j);
        this.zCam = halfSquareFeet - 40 - this.setBacks[dirToViewer];
        g2.setColor(Color.black);
        if (j.isTwoWayDivided()) {
            this.drawTwoWayDivided(g2, j);
        } else {
            this.drawSurfaceIntersection(g2, j);
        }
        if (j.intersectionType() == 2) {
            this.drawStripesAcross(g2, j);
        } else {
            this.drawIntersectionStripes(g2, j);
        }
        if (!j.isEmpty(Junction.getReverseDirection(this.aheadDir))) {
            if (j.ridToLeftDir(this.aheadDir) >= 0) {
                this.left.setLocation(postX, postY);
                this.left.draw(g2);
                postX += 48;
                ++nRoutePosts;
            }
            if (j.ridAt(this.aheadDir, 0) > 0) {
                this.ahead.setLocation(postX, postY);
                this.ahead.draw(g2);
                postX += 48;
                ++nRoutePosts;
            }
            if (j.ridToRightDir(this.aheadDir) >= 0) {
                this.right.setLocation(postX, postY);
                this.right.draw(g2);
                ++nRoutePosts;
            }
            this.street.setLocation(streetX += offset[nRoutePosts], postY);
            this.street.draw(g2, nRoutePosts == 0);
        }
    }

    public void movePlayer(Point where, int dirFacing) {
        this.sqPlayer.setLocation(where);
        this.aheadDir = dirFacing;
        this.zCam = halfSquareFeet - 80;
        this.left.setRoutes(this.myRealm, this.sqPlayer, this.aheadDir, 6);
        this.ahead.setRoutes(this.myRealm, this.sqPlayer, this.aheadDir, 0);
        this.right.setRoutes(this.myRealm, this.sqPlayer, this.aheadDir, 2);
        this.street.setSids(this.myRealm, this.sqPlayer, this.aheadDir);
        this.repaint();
    }
}

