/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.Empire;
import com.kurumi.matr.Junction;
import com.kurumi.matr.MyTools;
import com.kurumi.matr.Realm;
import com.kurumi.matr.Route;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class HighwayLogViewer
extends JFrame {
    private JTextArea myText = new JTextArea("", 40, 30);
    private JButton bShow = new JButton("Show Route:");
    private JButton bShowAll = new JButton("Show All");
    private Realm myRealm;
    private boolean showAll = true;
    private TextField tfRoute = new TextField(4);
    private int routeToShow = 0;

    private static String mile100String(int centimiles) {
        return String.format("%d.%02d", centimiles / 100, centimiles % 100);
    }

    public void refresh() {
        this.buildLog();
    }

    HighwayLogViewer(Realm realm) {
        super("Highway Log");
        this.myRealm = realm;
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        Container pane = this.getContentPane();
        this.bShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HighwayLogViewer.this.showAll = false;
                HighwayLogViewer.this.routeToShow = MyTools.atoi(HighwayLogViewer.this.tfRoute.getText());
                HighwayLogViewer.this.buildLog();
            }
        });
        this.bShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HighwayLogViewer.this.showAll = true;
                HighwayLogViewer.this.buildLog();
            }
        });
        JPanel textAreaPanel = new JPanel();
        textAreaPanel.add(new JScrollPane(this.myText));
        this.myText.setEditable(false);
        pane.add((Component)textAreaPanel, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.bShow);
        buttonsPanel.add(this.tfRoute);
        buttonsPanel.add(this.bShowAll);
        pane.add((Component)buttonsPanel, "Last");
        this.buildLog();
        this.pack();
    }

    private int logOneRoute(Route route) {
        int newTownId;
        Point here = new Point();
        Point end = new Point();
        int my100s = 0;
        route.clearLog();
        route.appendToLog("Route " + route.getNumber() + "\n");
        here.setLocation(route.getStart());
        end.setLocation(route.getEnd());
        int oldTownId = newTownId = this.myRealm.grid[here.x][here.y].getTown();
        int endTownId = this.myRealm.grid[end.x][end.y].getTown();
        route.appendToLog("From: " + this.myRealm.pToJ(here).describe(this.myRealm, route.getId()) + " " + this.myRealm.towns[newTownId].getName() + "\n");
        route.appendToLog("To: " + this.myRealm.pToJ(end).describe(this.myRealm, route.getId()) + " " + this.myRealm.towns[endTownId].getName() + "\n");
        route.appendToLog("Log dir: " + Junction.dirStrings[route.getLogDirection()] + "\nMileposts:\n");
        while (true) {
            String s;
            if ((s = this.myRealm.pToJ(here).describe(this.myRealm, route.getId())).length() > 0) {
                route.appendToLog(HighwayLogViewer.mile100String(my100s) + ": " + s + "\n");
            }
            if (!this.myRealm.nextJunc(here, route.getId())) break;
            int lengthIncrement = 20;
            if (this.myRealm.pToJ(here).ridLeavesDiagonally(route.getId())) {
                lengthIncrement = 20;
            }
            int halfIncrement = lengthIncrement / 2;
            newTownId = this.myRealm.grid[here.x][here.y].getTown();
            if (newTownId != oldTownId) {
                route.appendToLog(HighwayLogViewer.mile100String(my100s + halfIncrement) + ": ");
                route.appendToLog(this.myRealm.towns[oldTownId].getName() + " - " + this.myRealm.towns[newTownId].getName() + " TL\n");
            }
            oldTownId = newTownId;
            my100s += lengthIncrement;
        }
        return my100s;
    }

    private void logAllRoutes() {
        int total100s = 0;
        TreeMap<Integer, Route> treeMap = new TreeMap<Integer, Route>();
        for (int i = 1; i <= this.myRealm.getNumRoutes(); ++i) {
            total100s += this.logOneRoute(this.myRealm.routes[i]);
            treeMap.put(this.myRealm.routes[i].getNumber(), this.myRealm.routes[i]);
        }
        StringBuffer completeHighwayLog = new StringBuffer();
        TreeSet keys = new TreeSet(treeMap.keySet());
        for (Integer key : keys) {
            completeHighwayLog.append(((Route)treeMap.get(key)).getLog());
            completeHighwayLog.append("\n\n");
        }
        completeHighwayLog.append("\nNumbered routes: " + this.myRealm.getNumRoutes() + "\n");
        completeHighwayLog.append("\nTotal mileage: " + HighwayLogViewer.mile100String(total100s) + "\n");
        this.myText.setText("");
        this.myText.setFont(Empire.routeLogFont);
        this.myText.setText(completeHighwayLog.toString());
    }

    private void buildLog() {
        if (this.showAll) {
            this.logAllRoutes();
            return;
        }
        int rid = this.myRealm.getRouteId(this.routeToShow);
        if (rid <= 0) {
            this.myText.setText("Route " + this.routeToShow + " doesn't exist.");
        } else {
            this.logOneRoute(this.myRealm.routes[rid]);
            this.myText.setText(this.myRealm.routes[rid].getLog().toString());
        }
    }
}

