/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.Changer;
import com.kurumi.matr.FontPreview;
import com.kurumi.matr.HighwayLogViewer;
import com.kurumi.matr.IntersectionViewerFrame;
import com.kurumi.matr.Junction;
import com.kurumi.matr.MatrPanel;
import com.kurumi.matr.MyTools;
import com.kurumi.matr.Realm;
import com.kurumi.matr.RoadMapFrame;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;

public class Empire
implements MatrPanel {
    static final boolean expertMode = true;
    static final int defaultHeight = 64;
    static final int defaultWidth = 100;
    static final int defaultNumRoutes = 10;
    static final String appTitle = "Me and the Roads";
    public static Font routeLogFont = new Font("Helvetica", 0, 10);
    public static Font townFont = new Font("Helvetica", 0, 12);
    public static Font dirTabFont = new Font("Arial Narrow", 1, 12);
    public static Font routeTabFont = new Font("Helvetica", 1, 18);
    Realm myRealm;
    TextField tw;
    TextField th;
    TextField tr;
    Button bCreate = new Button("Create");
    Button bMap = new Button("Map");
    Button bLog = new Button("Log");
    Button bView = new Button("View");
    Button bChange = new Button("Rename");
    Button bFontPreview = new Button("Fonts");
    JFrame myFrame;
    RoadMapFrame map;
    IntersectionViewerFrame viewer;
    HighwayLogViewer routeLog;
    Changer renamer;

    public static void main(String[] args) {
        new Empire().init();
    }

    public void init() {
        this.myFrame = new JFrame(appTitle);
        this.myFrame.setBounds(50, 50, 480, 80);
        this.setHandlers();
        this.myFrame.setLayout(new GridLayout(0, 1));
        this.tw = new TextField("100", 5);
        this.th = new TextField("64", 5);
        this.tr = new TextField("10", 5);
        Panel p = new Panel();
        p.setLayout(new FlowLayout(0));
        p.add(new Label("width:"));
        p.add(this.tw);
        p.add(new Label("height:"));
        p.add(this.th);
        p.add(new Label("routes:"));
        p.add(this.tr);
        this.myFrame.add(p);
        p = new Panel();
        p.setLayout(new FlowLayout(2));
        p.add(this.bCreate);
        p.add(this.bMap);
        p.add(this.bLog);
        p.add(this.bView);
        p.add(this.bChange);
        this.disableToolButtons();
        this.myFrame.add(p);
        this.myFrame.pack();
        this.myFrame.setVisible(true);
    }

    private void newMap() {
        if (this.map != null) {
            this.map.setVisible(false);
        }
        this.map = new RoadMapFrame(this.myRealm, this);
        this.bMap.setEnabled(true);
    }

    private void newHighwayLog() {
        if (this.routeLog != null) {
            this.routeLog.setVisible(false);
        }
        this.routeLog = new HighwayLogViewer(this.myRealm);
    }

    private void newViewer() {
        if (this.viewer != null) {
            this.viewer.setVisible(false);
        }
        this.viewer = new IntersectionViewerFrame(this.myRealm);
    }

    private void newRenamer() {
        if (this.renamer != null) {
            this.renamer.hide();
        }
        this.renamer = new Changer(this.myRealm, this);
    }

    private void newFontPreview() {
        new FontPreview(this).show();
    }

    private void setHandlers() {
        this.bCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int nw = MyTools.atoi(Empire.this.tw.getText());
                int nh = MyTools.atoi(Empire.this.th.getText());
                int nr = MyTools.atoi(Empire.this.tr.getText());
                Empire.this.disableToolButtons();
                Empire.this.myRealm = new Realm(nw, nh, nr);
                Empire.this.myRealm.create();
                Empire.this.bCreate.setEnabled(false);
                Empire.this.newMap();
                Empire.this.bMap.setEnabled(true);
                Empire.this.newHighwayLog();
                Empire.this.bLog.setEnabled(true);
                Empire.this.newViewer();
                Empire.this.bView.setEnabled(true);
                Empire.this.newRenamer();
                Empire.this.bChange.setEnabled(true);
            }
        });
        this.bMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Empire.this.map.setVisible(true);
            }
        });
        this.bLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Empire.this.routeLog.setVisible(true);
            }
        });
        this.bView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Empire.this.viewer.setVisible(true);
            }
        });
        this.bChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Empire.this.renamer.show();
            }
        });
        this.bFontPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Empire.this.newFontPreview();
            }
        });
    }

    private void disableToolButtons() {
        this.bMap.setEnabled(false);
        this.bLog.setEnabled(false);
        this.bView.setEnabled(false);
        this.bChange.setEnabled(false);
    }

    @Override
    public void setPlayerLocation(int x, int y) {
        this.viewer.setViewerLocation(x, y);
    }

    @Override
    public void askRefresh(int whichOnes) {
        if (this.map != null && (whichOnes & 1) != 0) {
            this.map.refresh();
        }
        if (this.routeLog != null && (whichOnes & 2) != 0) {
            this.routeLog.refresh();
        }
        if (this.viewer != null && (whichOnes & 4) != 0) {
            this.viewer.refresh();
        }
    }

    private static void updateFont(Component c) {
        if (c != null && c.isVisible()) {
            c.repaint();
        }
    }

    @Override
    public void fontChanged() {
        Empire.updateFont(this.map);
        Empire.updateFont(this.routeLog);
        Empire.updateFont(this.viewer);
        this.askRefresh(7);
    }

    @Override
    public void infoCopiedFromMap(Point square, int octant) {
        Junction j = this.myRealm.pToJ(square);
        String route = "";
        int rid = j.ridAt(octant, 0);
        if (rid > 0) {
            route = "" + this.myRealm.routes[rid].getNumber();
        }
        String street = "";
        int sid = j.sidAt(octant);
        if (sid > 1) {
            street = this.myRealm.streetNames[sid];
        }
        String town = this.myRealm.towns[this.myRealm.grid[square.x][square.y].getTown()].getName();
        if (this.renamer != null) {
            this.renamer.setOldRoute(route);
            this.renamer.setOldStreet(street);
            this.renamer.setOldTown(town);
        }
    }
}

