/*
 * Decompiled with CFR 0.152.
 */
package com.kurumi.matr;

import com.kurumi.matr.MatrPanel;
import com.kurumi.matr.MyTools;
import com.kurumi.matr.Realm;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class Changer {
    JTextField tfOldRoute = new JTextField(6);
    JTextField tfNewRoute = new JTextField(6);
    JButton bcRoute = new JButton("Change");
    JTextField tfOldStreet = new JTextField(18);
    JTextField tfNewStreet = new JTextField(18);
    JButton bcStreet = new JButton("Change");
    JTextField tfOldTown = new JTextField(18);
    JTextField tfNewTown = new JTextField(18);
    JButton bcTown = new JButton("Change");
    JButton bClose = new JButton("Close");
    Label laMessage = new Label();
    Realm myRealm;
    MatrPanel mp;
    JFrame frame = new JFrame("Renumber/Rename Tool");

    Changer(Realm r, MatrPanel mp_) {
        this.myRealm = r;
        this.mp = mp_;
        this.frame.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        int row = 0;
        MyTools.setLeftNoFill(c1, 1, row);
        this.frame.add((Component)new Label("Is:"), c1);
        ++c1.gridx;
        this.frame.add((Component)new Label("Should be:"), c1);
        MyTools.setLeftNoFill(c1, 0, ++row);
        this.frame.add((Component)new Label("Route:"), c1);
        ++c1.gridx;
        this.frame.add((Component)this.tfOldRoute, c1);
        ++c1.gridx;
        this.frame.add((Component)this.tfNewRoute, c1);
        ++c1.gridx;
        this.frame.add((Component)this.bcRoute, c1);
        MyTools.setLeftNoFill(c1, 0, ++row);
        this.frame.add((Component)new Label("Street:"), c1);
        ++c1.gridx;
        this.frame.add((Component)this.tfOldStreet, c1);
        ++c1.gridx;
        this.frame.add((Component)this.tfNewStreet, c1);
        ++c1.gridx;
        this.frame.add((Component)this.bcStreet, c1);
        MyTools.setLeftNoFill(c1, 0, ++row);
        this.frame.add((Component)new Label("Town:"), c1);
        ++c1.gridx;
        this.frame.add((Component)this.tfOldTown, c1);
        ++c1.gridx;
        this.frame.add((Component)this.tfNewTown, c1);
        ++c1.gridx;
        this.frame.add((Component)this.bcTown, c1);
        MyTools.setAllWide(c1, ++row);
        this.frame.add((Component)new JSeparator(0), c1);
        MyTools.setAllWide(c1, ++row);
        MyTools.setLastRow(c1);
        this.frame.add((Component)this.laMessage, c1);
        MyTools.setAllWide(c1, ++row);
        c1.weightx = 1.0;
        this.frame.add((Component)new JSeparator(0), c1);
        MyTools.setLeftNoFill(c1, 3, ++row);
        MyTools.setLastRow(c1);
        this.frame.add((Component)this.bClose, c1);
        this.bcRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Changer.this.changeRoute();
            }
        });
        this.bcStreet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Changer.this.changeStreet();
            }
        });
        this.bcTown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Changer.this.changeTown();
            }
        });
        this.bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Changer.this.frame.setVisible(false);
            }
        });
        this.frame.pack();
    }

    private void changeRoute() {
        int oldRoute = MyTools.atoi(this.tfOldRoute.getText());
        int newRoute = MyTools.atoi(this.tfNewRoute.getText());
        if (!this.myRealm.routeExists(oldRoute)) {
            this.errorMessage("Route " + oldRoute + " doesn't exist.");
            return;
        }
        if (this.myRealm.routeExists(newRoute)) {
            this.errorMessage("There already is a route " + newRoute + ".");
            return;
        }
        this.myRealm.changeRoute(oldRoute, newRoute);
        this.clearErrorMessage();
        this.mp.askRefresh(7);
    }

    private void changeStreet() {
        String oldStreet = this.tfOldStreet.getText();
        String newStreet = this.tfNewStreet.getText();
        if (!this.myRealm.streetExists(oldStreet)) {
            this.errorMessage("'" + oldStreet + "' doesn't exist.");
            return;
        }
        if (this.myRealm.streetExists(newStreet)) {
            this.errorMessage("There already is a '" + newStreet + "'.");
            return;
        }
        this.myRealm.changeStreet(oldStreet, newStreet);
        this.clearErrorMessage();
        this.mp.askRefresh(7);
    }

    private void changeTown() {
        String oldTown = this.tfOldTown.getText();
        String newTown = this.tfNewTown.getText();
        if (!this.myRealm.townExists(oldTown)) {
            this.errorMessage("The town '" + oldTown + "' doesn't exist.");
            return;
        }
        if (this.myRealm.townExists(newTown)) {
            this.errorMessage("There already is a town named '" + newTown + "'.");
            return;
        }
        this.myRealm.changeTown(oldTown, newTown);
        this.clearErrorMessage();
        this.mp.askRefresh(7);
    }

    private void errorMessage(String msg) {
        this.laMessage.setText(msg);
        this.frame.validate();
    }

    private void clearErrorMessage() {
        this.errorMessage("");
    }

    public void setOldRoute(String number) {
        this.tfOldRoute.setText(number);
    }

    public void setOldStreet(String name) {
        this.tfOldStreet.setText(name);
    }

    public void setOldTown(String name) {
        this.tfOldTown.setText(name);
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void hide() {
        this.frame.setVisible(false);
    }
}

